/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.desktop.tools_menu;

import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.GDialog;
import fr.geraidv3.desktop.tools_menu.Presenter;
import fr.geraidv3.model.GlobalSettings;
import fr.geraidv3.utils.ExcludeFromJacocoGeneratedReport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

@ExcludeFromJacocoGeneratedReport
public class QrCodeGenerator
extends GDialog {
    private final List<JCheckBox> _checkboxes = new ArrayList<JCheckBox>();
    private final Presenter _presenter;
    private final JTextField _textField = new JTextField();

    public QrCodeGenerator(DesktopView desktopView, GlobalSettings globalSettings, String raidName, List<String> parcoursNames) {
        super(desktopView);
        this._presenter = new Presenter(this, globalSettings);
        this.setTitle(L10n.getString("qr_code.window.title"));
        this.setModal(true);
        this._initializeUI(globalSettings, raidName, parcoursNames);
        this.pack();
    }

    private void _initializeUI(GlobalSettings globalSettings, String raidName, List<String> parcoursNames) {
        JPanel panel = new JPanel(new BorderLayout(8, 8));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.add((Component)this._createUrlPanel(globalSettings), "North");
        panel.add((Component)this._createCheckboxPanel(parcoursNames), "Center");
        panel.add((Component)this._createButtonPanel(raidName, parcoursNames), "South");
        this.add(panel);
    }

    private JPanel _createUrlPanel(GlobalSettings globalSettings) {
        JPanel panel = new JPanel();
        String url = globalSettings.getPublicationUrl();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel label = new JLabel(L10n.getString("qr_code.text.label"));
        this._textField.setColumns(20);
        this._textField.setText(url);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(this._textField);
        return panel;
    }

    private JComponent _createCheckboxPanel(List<String> parcoursNames) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JLabel(L10n.getString("qr_code.parcours.parcours.label")));
        JPanel panel1 = new JPanel();
        panel1.setBorder(BorderFactory.createEmptyBorder(8, 20, 8, 0));
        panel1.setLayout(new BoxLayout(panel1, 1));
        for (String parcoursName : parcoursNames) {
            JCheckBox checkBox = new JCheckBox(parcoursName);
            this._checkboxes.add(checkBox);
            panel1.add(checkBox);
        }
        panel.add(panel1);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(panel);
        return scrollPane;
    }

    private JPanel _createButtonPanel(String raidName, List<String> parcoursNames) {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton generateButton = new JButton(L10n.getString("qr_code.generate.button"));
        this.setDefaultButton(generateButton);
        generateButton.addActionListener(e -> {
            ArrayList<String> selectedParcoursNames = new ArrayList<String>();
            for (int i = 0; i < this._checkboxes.size(); ++i) {
                if (!this._checkboxes.get(i).isSelected()) continue;
                selectedParcoursNames.add((String)parcoursNames.get(i));
            }
            if (this._presenter.generateQrCodes(this._textField.getText().trim(), selectedParcoursNames, raidName)) {
                this.dispose();
            }
        });
        JButton cancelButton = new JButton(L10n.getString("cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        this.setCancelButton(cancelButton);
        buttonPanel.add(generateButton);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }
}

