/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.balise;

import fr.geraidv3.model.balise.Balise;
import java.util.Vector;

public final class BaliseVector {
    private final Vector<Balise> _baliseVector = new Vector();

    public BaliseVector() {
    }

    public BaliseVector(BaliseVector baliseVector) {
        for (Balise balise : baliseVector._baliseVector) {
            this._baliseVector.add(new Balise(balise));
        }
    }

    public Vector<Balise> getBaliseVector() {
        return this._baliseVector;
    }

    public void addBalise(Balise balise) {
        this._baliseVector.add(balise);
    }

    public void removeBalise(Balise balise) {
        this._baliseVector.remove(balise);
    }

    public int getSize() {
        return this._baliseVector.size();
    }

    public void moveUpBalise(int index) {
        if (index > 0) {
            Balise balise = this._baliseVector.get(index);
            this._baliseVector.add(index - 1, balise);
            this._baliseVector.remove(index + 1);
        }
    }

    public void moveDownBalise(int index) {
        if (index < this._baliseVector.size() - 1) {
            Balise balise = this._baliseVector.get(index);
            this._baliseVector.add(index + 2, balise);
            this._baliseVector.remove(index);
        }
    }

    public int getTotalPoints() {
        int total = 0;
        for (Balise balise : this._baliseVector) {
            if (balise.getPunchPointsBonus() <= 0) continue;
            total += balise.getPunchPointsBonus();
        }
        return total;
    }

    public int getFirstBaliseNumber() {
        if (this.getSize() > 0) {
            return this._baliseVector.get(0).getNumber();
        }
        return 30;
    }

    public int getLastBaliseNumber() {
        if (this.getSize() > 0) {
            return ((Balise)this._baliseVector.getLast()).getNumber();
        }
        return 30;
    }

    public int getHigherBaliseNumber() {
        int number = 30;
        for (Balise balise : this._baliseVector) {
            if (balise.getNumber() <= number) continue;
            number = balise.getNumber();
        }
        return number;
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder("<ul>");
        for (Balise balise : this._baliseVector) {
            html.append(balise.toHtml());
        }
        html.append("</ul>");
        return html.toString();
    }

    public void replaceBalise(int oldCode, int newCode) {
        for (Balise balise : this._baliseVector) {
            if (balise.getNumber() != oldCode) continue;
            balise.setNumber(newCode);
        }
    }
}

