/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.categorie;

import fr.geraidv3.model.categorie.Categorie;
import java.util.Vector;

public final class CategorieVector {
    private final Vector<Categorie> _categorieVector;

    public CategorieVector() {
        this._categorieVector = new Vector();
    }

    public CategorieVector(CategorieVector categoriesTemplate) {
        this._categorieVector = new Vector(categoriesTemplate.getSize());
        this._categorieVector.addAll(categoriesTemplate.getCategorieVector());
    }

    public Vector<Categorie> getCategorieVector() {
        return this._categorieVector;
    }

    public Categorie getCategorieFromShortName(String shortName) {
        for (Categorie category : this._categorieVector) {
            if (!category.getShortName().equals(shortName)) continue;
            return category;
        }
        return null;
    }

    public void addCategorie(Categorie categorie) {
        if (!this.existsCategorie(categorie.getLongName(), categorie.getShortName())) {
            this._categorieVector.add(categorie);
        }
    }

    public String[][] getData() {
        String[][] data = new String[this._categorieVector.size()][2];
        for (int i = 0; i < this._categorieVector.size(); ++i) {
            Categorie categorie = this._categorieVector.get(i);
            data[i][0] = categorie.getLongName();
            data[i][1] = categorie.getShortName();
        }
        return data;
    }

    public void removeCategorieWithShortName(String longName) {
        for (int i = 0; i < this._categorieVector.size(); ++i) {
            if (!longName.equals(this._categorieVector.get(i).getShortName())) continue;
            this._categorieVector.remove(this._categorieVector.get(i));
            return;
        }
    }

    public boolean existsCategorie(String longName, String shortName) {
        String longName1 = longName.toLowerCase();
        String shortName1 = shortName.toLowerCase();
        for (Categorie category : this._categorieVector) {
            String categoryLongName = category.getLongName().toLowerCase();
            String categoryShortName = category.getShortName().toLowerCase();
            if (!longName1.equals(categoryLongName) && !shortName1.equals(categoryShortName)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this._categorieVector.size();
    }

    public void clear() {
        this._categorieVector.clear();
    }

    public boolean existsCategorieWithShortName(String shortName) {
        for (Categorie category : this._categorieVector) {
            if (!shortName.equals(category.getShortName())) continue;
            return true;
        }
        return false;
    }
}

