/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.EpreuveFactory;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.EpreuveVector;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public abstract class Epreuve {
    private final Balise _globalBaliseModel;
    private BaliseVector _baliseVector = new BaliseVector();
    private Balise _baliseModel;
    private String _name = "";
    private LimitType _limitType = LimitType.SANSLIMITE;
    private Date _durationLimit = new Date(0L);
    private int _penaltyIntervalInMn = 5;
    private int _penaltyPoints = 0;
    private int _penaltyTimeInMn = 0;
    private boolean _variante = false;
    private boolean _backAndForth = false;

    protected Epreuve(Balise balise) {
        this._globalBaliseModel = balise;
    }

    public BaliseVector getBaliseVector() {
        return this._baliseVector;
    }

    public void setBaliseVector(BaliseVector baliseVector) {
        this._baliseVector = baliseVector;
    }

    public abstract boolean isAscenseur();

    public abstract void setAscenseur(boolean var1);

    public abstract String getIsAscenseurAsString();

    public boolean isBackAndForth() {
        return this._backAndForth;
    }

    public void setBackAndForth(boolean backAndForth) {
        this._backAndForth = backAndForth;
    }

    public String getIsBackAndForthAsString() {
        return this._backAndForth ? "1" : "0";
    }

    public Balise getBaliseModel() {
        if (this._baliseModel == null) {
            return this._globalBaliseModel;
        }
        return this._baliseModel;
    }

    public Balise getLocalBaliseModel() {
        return this._baliseModel;
    }

    public void setLocalBaliseModel(Balise baliseModel) {
        this._baliseModel = baliseModel == null ? null : new Balise(baliseModel);
    }

    public void removeLocalBaliseModel() {
        this._baliseModel = null;
    }

    public Balise getGlobalBaliseModel() {
        return this._globalBaliseModel;
    }

    public int getTotalPoints() {
        return this._baliseVector.getTotalPoints();
    }

    public abstract int getTimeMultiplier();

    public abstract void setTimeMultiplier(int var1);

    public int[] getCodes() {
        int[] codes = new int[this.getNbBalises()];
        Vector<Balise> baliseVector = this._baliseVector.getBaliseVector();
        for (int i = 0; i < baliseVector.size(); ++i) {
            codes[i] = ((Balise)baliseVector.get(i)).getNumber();
        }
        return codes;
    }

    public abstract boolean isTimed();

    public abstract void setTimed(boolean var1);

    public abstract String getIsTimeAsString();

    public int getPenaltyTimeInMn() {
        return this._penaltyTimeInMn;
    }

    public void setPenaltyTimeInMn(int minutes) {
        this._penaltyTimeInMn = minutes;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return this._name;
    }

    public LimitType getLimitType() {
        return this._limitType;
    }

    public void setLimitType(LimitType limitType) {
        this._limitType = limitType;
    }

    public abstract Date getTimeLimit();

    public abstract void setTimeLimit(Date var1);

    public Date getDurationLimit() {
        return this._durationLimit;
    }

    public void setDurationLimit(Date duration) {
        this._durationLimit = duration;
    }

    public int getPenaltyIntervalInMn() {
        return this._penaltyIntervalInMn;
    }

    public void setPenaltyIntervalInMn(int interval) {
        this._penaltyIntervalInMn = interval;
    }

    public int getPenaltyPoints() {
        return this._penaltyPoints;
    }

    public void setPenaltyPoints(int points) {
        this._penaltyPoints = points;
    }

    public int getNbBalises() {
        return this._baliseVector.getSize();
    }

    public abstract boolean isEnLigne();

    public abstract void setEnLigne(boolean var1);

    public abstract boolean isStartTheLastBaliseOfPreviousEpreuve();

    public abstract void setStartTheLastBaliseOfPreviousEpreuve(boolean var1);

    public abstract boolean isFinishTheFirstBaliseOfNextEpreuve();

    public abstract void setFinishTheFirstBaliseOfNextEpreuve(boolean var1);

    public abstract String getDebutEpreuve();

    public abstract String getFinEpreuve();

    public abstract String getIsCourseInRowAsString();

    public abstract boolean isToBeDoneAfterFinish();

    public abstract void setToBeDoneAfterFinish(boolean var1);

    public abstract String getDoneAfterFinishAsString();

    public abstract boolean isExclusiveWithNextEpreuve();

    public abstract void setExclusiveWithNextEpreuve(boolean var1);

    public abstract String getExclusiveWithNextEpreuveAsString();

    public abstract boolean isToBeDoneBeforeNextEpreuve();

    public abstract void setToBeDoneBeforeNextEpreuve(boolean var1);

    public abstract String getIsBeforeNextEpreuveAsString();

    public abstract boolean isToBeDoneAfterPreviousEpreuve();

    public abstract void setToBeDoneAfterPreviousEpreuve(boolean var1);

    public abstract String getIsAfterPreviousEpreuveAsString();

    public boolean isVariante() {
        return this._variante;
    }

    public void setVariante(boolean variante) {
        this._variante = variante;
    }

    public String getVariantAsString() {
        return this.isVariante() ? "1" : "0";
    }

    public void replaceBalise(int oldCode, int newCode) {
        this._baliseVector.replaceBalise(oldCode, newCode);
    }

    public abstract EpreuveFactory getFactory();

    public abstract String getSymbol(boolean var1);

    public abstract void addBalise(Balise var1);

    public abstract void addBalisesFromNumbers(List<Integer> var1);

    public abstract long computeDurationInMs(Date var1, Date var2);

    public abstract EpreuveType getType();

    public void applyBaliseModelToAllBalises() {
        for (int i = 0; i < this._baliseVector.getBaliseVector().size(); ++i) {
            this._baliseVector.getBaliseVector().get(i).applyModel(this._baliseModel);
        }
    }

    int getHigherBaliseNumber() {
        return this._baliseVector.getHigherBaliseNumber();
    }

    int getLastBaliseNumber() {
        return this._baliseVector.getLastBaliseNumber();
    }

    int getFirstBaliseNumber() {
        return this._baliseVector.getFirstBaliseNumber();
    }

    abstract String toHtml(EpreuveVector var1);

    String toCSV() {
        StringBuilder csv = new StringBuilder(this._name);
        for (int i = 0; i < this._baliseVector.getSize(); ++i) {
            csv.append(";").append(this._baliseVector.getBaliseVector().get(i).getNumber());
        }
        return csv.toString();
    }
}

