/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveFactory;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.epreuve.GelEpreuveFactory;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public final class GelEpreuve
extends Epreuve {
    private static final int MAX_BALISE_NUMBER = 2;

    public GelEpreuve(Balise globalBaliseModel) {
        super(globalBaliseModel);
    }

    @Override
    public void setBaliseVector(BaliseVector baliseVector) {
        Vector<Balise> balises = baliseVector.getBaliseVector();
        int last = balises.size() - 1;
        balises.removeIf(balise -> balises.indexOf(balise) != 0 && balises.indexOf(balise) != last);
        balises.replaceAll(balise -> {
            balise.setFreezeTime(true);
            return balise;
        });
        super.setBaliseVector(baliseVector);
    }

    @Override
    public boolean isAscenseur() {
        return true;
    }

    @Override
    public void setAscenseur(boolean value) {
    }

    @Override
    public String getIsAscenseurAsString() {
        return "1";
    }

    @Override
    public int getTimeMultiplier() {
        return 1;
    }

    @Override
    public void setTimeMultiplier(int timeMultiplier) {
    }

    @Override
    public boolean isTimed() {
        return true;
    }

    @Override
    public void setTimed(boolean timed) {
    }

    @Override
    public String getIsTimeAsString() {
        return "1";
    }

    @Override
    public void setLimitType(LimitType limitType) {
        if (limitType != LimitType.AVECLIMITEHORAIRE) {
            super.setLimitType(limitType);
        }
    }

    @Override
    public Date getTimeLimit() {
        return DateTimeUtils.NO_TIME;
    }

    @Override
    public void setTimeLimit(Date timeLimit) {
    }

    @Override
    public boolean isEnLigne() {
        return false;
    }

    @Override
    public void setEnLigne(boolean enLigne) {
    }

    @Override
    public boolean isStartTheLastBaliseOfPreviousEpreuve() {
        return false;
    }

    @Override
    public void setStartTheLastBaliseOfPreviousEpreuve(boolean firstBaliseStartOfEpreuve) {
    }

    @Override
    public boolean isFinishTheFirstBaliseOfNextEpreuve() {
        return false;
    }

    @Override
    public void setFinishTheFirstBaliseOfNextEpreuve(boolean finishOfEpreuve) {
    }

    @Override
    public String getDebutEpreuve() {
        return "0";
    }

    @Override
    public String getFinEpreuve() {
        return "0";
    }

    @Override
    public String getIsCourseInRowAsString() {
        return "0";
    }

    @Override
    public boolean isToBeDoneAfterFinish() {
        return false;
    }

    @Override
    public void setToBeDoneAfterFinish(boolean value) {
    }

    @Override
    public String getDoneAfterFinishAsString() {
        return "0";
    }

    @Override
    public boolean isExclusiveWithNextEpreuve() {
        return false;
    }

    @Override
    public void setExclusiveWithNextEpreuve(boolean exclusiveWithNextEpreuve) {
    }

    @Override
    public String getExclusiveWithNextEpreuveAsString() {
        return "0";
    }

    @Override
    public boolean isToBeDoneBeforeNextEpreuve() {
        return false;
    }

    @Override
    public void setToBeDoneBeforeNextEpreuve(boolean toBeDoneBeforeNextEpreuve) {
    }

    @Override
    public String getIsBeforeNextEpreuveAsString() {
        return "0";
    }

    @Override
    public boolean isToBeDoneAfterPreviousEpreuve() {
        return false;
    }

    @Override
    public void setToBeDoneAfterPreviousEpreuve(boolean toBeDoneAfterPreviousEpreuve) {
    }

    @Override
    public String getIsAfterPreviousEpreuveAsString() {
        return "0";
    }

    @Override
    public EpreuveFactory getFactory() {
        return new GelEpreuveFactory();
    }

    @Override
    public String getSymbol(boolean isSelected) {
        String color = isSelected ? "#00dddd" : "#00aaaa";
        return "<span style='color:" + color + ";font-weight:bold;font-size:medium'>&#10052; </span>";
    }

    @Override
    public void addBalise(Balise balise) {
        balise.setFreezeTime(true);
        if (this.getBaliseVector().getSize() < 2) {
            this.getBaliseVector().addBalise(balise);
        }
    }

    @Override
    public void addBalisesFromNumbers(List<Integer> list) {
        for (int number : list) {
            Balise balise = new Balise(number);
            balise.setFreezeTime(true);
            balise.applyModel(this.getBaliseModel());
            if (this.getBaliseVector().getSize() >= 2) continue;
            this.getBaliseVector().addBalise(balise);
        }
    }

    @Override
    public long computeDurationInMs(Date startTime, Date finishTime) {
        return 0L;
    }

    @Override
    public EpreuveType getType() {
        return EpreuveType.GEL;
    }

    @Override
    String toHtml(EpreuveVector epreuves) {
        StringBuilder html = new StringBuilder();
        html.append("<li><b>Section de gel : ").append(this.getName()).append("</b><br>");
        switch (this.getLimitType()) {
            case SANSLIMITE: {
                html.append("Sans limite de temps.");
                break;
            }
            case AVECLIMITETEMPS: {
                html.append("Avec limite de dur\u00e9e \u00e0 ").append(DateTimeUtils.dateToString(this.getDurationLimit())).append(" et p\u00e9nalit\u00e9 de ").append(this.getPenaltyPoints()).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this.getPenaltyTimeInMn() * 60000L)).append(" par ").append(this.getPenaltyIntervalInMn()).append(" mn de d\u00e9passement.");
                break;
            }
            case AVECLIMITEHORAIRE: {
                html.append("Avec limite horaire \u00e0 ").append(DateTimeUtils.dateToString(this.getTimeLimit())).append(" et p\u00e9nalit\u00e9 de ").append(this.getPenaltyPoints()).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this.getPenaltyTimeInMn() * 60000L)).append(" par ").append(this.getPenaltyIntervalInMn()).append(" mn de d\u00e9passement.");
                break;
            }
        }
        html.append("<br>");
        html.append("Gel du chronom\u00e8tre entre ");
        html.append("la balise ").append(this.getBaliseVector().getFirstBaliseNumber()).append(" et ");
        html.append("la balise ").append(this.getBaliseVector().getLastBaliseNumber()).append(".");
        html.append("<br>");
        html.append(this.getBaliseVector().toHtml());
        return html.toString();
    }
}

