/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.epreuve;

import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveFactory;
import fr.geraidv3.model.epreuve.EpreuveType;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.epreuve.StandardEpreuveFactory;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public final class StandardEpreuve
extends Epreuve {
    private Date _timeLimit = new Date(0L);
    private int _timeMultiplier = 1;
    private boolean _isTimed = true;
    private boolean _enLigne = false;
    private boolean _isStartLastBaliseOfPreviousEpreuve = false;
    private boolean _isFinishFirstBaliseOfNextEpreuve = false;
    private boolean _toBeDoneAfterFinish = false;
    private boolean _toBeDoneBeforeNextEpreuve = false;
    private boolean _toBeDoneAfterPreviousEpreuve = false;
    private boolean _exclusiveWithNextEpreuve = false;
    private boolean _ascenseur = false;

    @VisibleForTesting
    public StandardEpreuve() {
        super(null);
    }

    public StandardEpreuve(Balise globalBaliseModel) {
        super(globalBaliseModel);
    }

    @Override
    public boolean isAscenseur() {
        return this._ascenseur;
    }

    @Override
    public void setAscenseur(boolean value) {
        this._ascenseur = value;
    }

    @Override
    public String getIsAscenseurAsString() {
        return this._ascenseur ? "1" : "0";
    }

    @Override
    public int getTimeMultiplier() {
        return this._timeMultiplier;
    }

    @Override
    public void setTimeMultiplier(int timeMultiplier) {
        this._timeMultiplier = timeMultiplier;
    }

    @Override
    public boolean isTimed() {
        return this._isTimed;
    }

    @Override
    public void setTimed(boolean timed) {
        this._isTimed = timed;
    }

    @Override
    public String getIsTimeAsString() {
        return this.isTimed() ? "1" : "0";
    }

    @Override
    public Date getTimeLimit() {
        return this._timeLimit;
    }

    @Override
    public void setTimeLimit(Date timeLimit) {
        this._timeLimit = timeLimit;
    }

    @Override
    public boolean isEnLigne() {
        return this._enLigne;
    }

    @Override
    public void setEnLigne(boolean enLigne) {
        this._enLigne = enLigne;
    }

    @Override
    public boolean isStartTheLastBaliseOfPreviousEpreuve() {
        return this._isStartLastBaliseOfPreviousEpreuve;
    }

    @Override
    public void setStartTheLastBaliseOfPreviousEpreuve(boolean value) {
        this._isStartLastBaliseOfPreviousEpreuve = value;
    }

    @Override
    public boolean isFinishTheFirstBaliseOfNextEpreuve() {
        return this._isFinishFirstBaliseOfNextEpreuve;
    }

    @Override
    public void setFinishTheFirstBaliseOfNextEpreuve(boolean finishOfEpreuve) {
        this._isFinishFirstBaliseOfNextEpreuve = finishOfEpreuve;
    }

    @Override
    public String getDebutEpreuve() {
        return this.isStartTheLastBaliseOfPreviousEpreuve() ? "1" : "0";
    }

    @Override
    public String getFinEpreuve() {
        return this.isFinishTheFirstBaliseOfNextEpreuve() ? "1" : "0";
    }

    @Override
    public String getIsCourseInRowAsString() {
        return this.isEnLigne() ? "1" : "0";
    }

    @Override
    public boolean isToBeDoneAfterFinish() {
        return this._toBeDoneAfterFinish;
    }

    @Override
    public void setToBeDoneAfterFinish(boolean value) {
        this._toBeDoneAfterFinish = value;
    }

    @Override
    public String getDoneAfterFinishAsString() {
        return this.isToBeDoneAfterFinish() ? "1" : "0";
    }

    @Override
    public boolean isExclusiveWithNextEpreuve() {
        return this._exclusiveWithNextEpreuve;
    }

    @Override
    public void setExclusiveWithNextEpreuve(boolean exclusiveWithNextEpreuve) {
        this._exclusiveWithNextEpreuve = exclusiveWithNextEpreuve;
    }

    @Override
    public String getExclusiveWithNextEpreuveAsString() {
        return this._exclusiveWithNextEpreuve ? "1" : "0";
    }

    @Override
    public boolean isToBeDoneBeforeNextEpreuve() {
        return this._toBeDoneBeforeNextEpreuve;
    }

    @Override
    public void setToBeDoneBeforeNextEpreuve(boolean toBeDoneBeforeNextEpreuve) {
        this._toBeDoneBeforeNextEpreuve = toBeDoneBeforeNextEpreuve;
    }

    @Override
    public String getIsBeforeNextEpreuveAsString() {
        return this.isToBeDoneBeforeNextEpreuve() ? "1" : "0";
    }

    @Override
    public boolean isToBeDoneAfterPreviousEpreuve() {
        return this._toBeDoneAfterPreviousEpreuve;
    }

    @Override
    public void setToBeDoneAfterPreviousEpreuve(boolean toBeDoneAfterPreviousEpreuve) {
        this._toBeDoneAfterPreviousEpreuve = toBeDoneAfterPreviousEpreuve;
    }

    @Override
    public String getIsAfterPreviousEpreuveAsString() {
        return this.isToBeDoneAfterPreviousEpreuve() ? "1" : "0";
    }

    @Override
    public EpreuveFactory getFactory() {
        return new StandardEpreuveFactory();
    }

    @Override
    public String getSymbol(boolean isSelected) {
        String color;
        String string = color = isSelected ? "#fea347" : "#ff7f00";
        if (this.isTimed()) {
            return "<span style='color:" + color + ";font-weight:bold;font-size:large'>&#9201; </span>";
        }
        return "<span style='color:" + color + ";font-weight:bold;font-size:large'>&#9706; </span>";
    }

    @Override
    public void addBalise(Balise balise) {
        this.getBaliseVector().addBalise(balise);
    }

    @Override
    public boolean isBackAndForth() {
        return false;
    }

    @Override
    public void setBackAndForth(boolean backAndForth) {
    }

    @Override
    public String getIsBackAndForthAsString() {
        return "0";
    }

    @Override
    public void addBalisesFromNumbers(List<Integer> list) {
        for (int number : list) {
            Balise balise = new Balise(number);
            balise.applyModel(this.getBaliseModel());
            this.getBaliseVector().addBalise(balise);
        }
    }

    @Override
    public long computeDurationInMs(Date startTime, Date finishTime) {
        if (this.isAscenseur()) {
            return DateTimeUtils.getAbsoluteElapsedTimeInMillis(startTime, finishTime);
        }
        return finishTime.getTime() - startTime.getTime();
    }

    @Override
    public EpreuveType getType() {
        return EpreuveType.EPREUVE;
    }

    @Override
    String toHtml(EpreuveVector epreuves) {
        StringBuilder html = new StringBuilder();
        html.append("<li><b>\u00c9preuve : ").append(this.getName()).append("</b><br>");
        switch (this.getLimitType()) {
            case SANSLIMITE: {
                html.append("Sans limite de temps");
                break;
            }
            case AVECLIMITETEMPS: {
                html.append("Avec limite de dur\u00e9e \u00e0 ").append(DateTimeUtils.dateToString(this.getDurationLimit())).append(" et p\u00e9nalit\u00e9 de ").append(this.getPenaltyPoints()).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this.getPenaltyTimeInMn() * 60000L)).append(" par ").append(this.getPenaltyIntervalInMn()).append(" mn de d\u00e9passement.");
                break;
            }
            case AVECLIMITEHORAIRE: {
                html.append("Avec limite horaire \u00e0 ").append(DateTimeUtils.dateToString(this.getTimeLimit())).append(" et p\u00e9nalit\u00e9 de ").append(this.getPenaltyPoints()).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this.getPenaltyTimeInMn() * 60000L)).append(" par ").append(this.getPenaltyIntervalInMn()).append(" mn de d\u00e9passement.");
                break;
            }
        }
        html.append("<br>");
        if (this.isTimed()) {
            html.append("\u00c9preuve chronom\u00e9tr\u00e9e entre ");
            if (epreuves.isFirstEpreuve(this)) {
                html.append("le d\u00e9part et ");
            } else if (this.isStartTheLastBaliseOfPreviousEpreuve()) {
                html.append("la balise ").append(epreuves.getLastCodeOfPreviousEpreuve(this)).append(" et ");
            } else {
                html.append("la balise ").append(this.getBaliseVector().getFirstBaliseNumber()).append(" et ");
            }
            if (epreuves.isLastEpreuveBeforeFinish(this)) {
                html.append("l'arriv\u00e9e.");
            } else if (this.isFinishTheFirstBaliseOfNextEpreuve()) {
                html.append("la balise ").append(epreuves.getFirstCodeOfNextEpreuve(this));
            } else {
                html.append("la balise ").append(this.getBaliseVector().getLastBaliseNumber()).append(".");
            }
            html.append("<br>");
        } else {
            html.append("\u00c9preuve non chronom\u00e9tr\u00e9e.<br>");
        }
        if (this.isToBeDoneAfterPreviousEpreuve()) {
            html.append("Postes \u00e0 valider apr\u00e8s l'\u00e9preuve pr\u00e9c\u00e9dente.<br>");
        }
        if (this.isToBeDoneBeforeNextEpreuve()) {
            html.append("Postes \u00e0 valider avant l'\u00e9preuve suivante.<br>");
        }
        if (this.getTimeMultiplier() > 1) {
            html.append("Temps de l'\u00e9preuve &#215; ").append(this.getTimeMultiplier()).append(".<br>");
        }
        if (this.isEnLigne()) {
            html.append("Postes \u00e0 valider en ordre impos\u00e9.<br>");
        } else {
            html.append("Postes \u00e0 valider en ordre libre.<br>");
        }
        if (this.isToBeDoneAfterFinish()) {
            html.append("Epreuve effectu\u00e9e apr\u00e8s l'arriv\u00e9e.<br>");
        }
        BaliseVector baliseVector = this.getBaliseVector();
        html.append("Nombre de balises : ").append(baliseVector.getSize());
        html.append(baliseVector.toHtml());
        html.append("</li>");
        return html.toString();
    }
}

