/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.equipe;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import fr.geraidv3.desktop.DesktopView;
import fr.geraidv3.desktop.swing_ext.ErrorPane;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.equipe.BadFileContent;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.model.parcours.ParcoursVector;
import fr.geraidv3.result.puce.PucesSpecificationsHandler;
import fr.geraidv3.utils.FileUtils;
import fr.geraidv3.utils.NumberUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.VisibleForTesting;

public final class CsvEquipeHelper {
    public static final int MEMBERS_START_COLUMN = 6;
    private static final String NOT_ENOUGH_PUCE = "csv_equipe_helper.specific_error.not_enough_puce";
    private static final String ERROR_FILE_WRITING = "csv_equipe_helper.error1";
    private static final String ERROR_FIND = "csv_equipe_helper.error5";
    private static final String ERROR_READ = "csv_equipe_helper.error4";
    private static final String ERROR_FORMAT = "csv_equipe_helper.error6";
    private static final String ERROR_MEMORY = "csv_equipe_helper.specific_error.puce_memory";
    private static final int DOSSARD_COLUMN = 0;
    private static final int EQUIPE_COLUMN = 1;
    private static final int PUCE_COLUMN = 2;
    private static final int CATEGORIE_COLUMN = 3;
    private static final int PARCOURS_COLUMN = 4;
    private static final int PHONE_COLUMN = 5;

    public static void exportEquipesTemplate(String filename) {
        File absoluteFilename = new File(filename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(absoluteFilename.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = L10n.getString("csv_equipe_helper.csv_export_equipe_header");
            writer.write(csvHeader);
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    public static void exportPucesTemplate(String filename) {
        File absoluteFilename = new File(filename);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(absoluteFilename.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = L10n.getString("csv_equipe_helper.csv_export_puce_header");
            writer.write(csvHeader);
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    public static void exportEquipes(Raid raid, String filename) {
        int option;
        File file = new File(filename);
        if (file.exists() && (option = JOptionPane.showConfirmDialog(GeRaidV3.getRootFrame(), L10n.getString("confirm_file_overwrite", filename), L10n.getString("confirmation_title"), 0, 2)) == 0) {
            CsvEquipeHelper.exportEquipes(raid, file);
        }
    }

    public static void importEquipesAndPuces(Raid raid, String equipeFile, String puceFile, Map<String, Integer> vacantEquipeParcours, int numberOfPucesPerEquipe) throws IOException, BadFileContent {
        List<String> puces = CsvEquipeHelper._readPucesFromFile(puceFile);
        Map<ParcoursVariante, List<Equipe>> equipeInParcours = CsvEquipeHelper._readEquipesFromFile(raid, equipeFile);
        CsvEquipeHelper._assignPucesToParcours(raid, equipeInParcours, puces, vacantEquipeParcours, numberOfPucesPerEquipe);
    }

    public static void importEquipes(Raid raid, String filename) throws IOException, BadFileContent {
        Map<ParcoursVariante, List<Equipe>> equipeInParcours = CsvEquipeHelper._readEquipesFromFile(raid, filename);
        CsvEquipeHelper._assignEquipeToParcours(equipeInParcours);
    }

    @VisibleForTesting
    static void exportEquipes(Raid raid, File file) {
        ParcoursVector parcoursVector = raid.getParcoursVector();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String csvHeader = L10n.getString("csv_equipe_helper.csv_export_equipe_header");
            writer.write(csvHeader);
            writer.write(System.lineSeparator());
            for (Parcours parcours : parcoursVector.getParcoursVector()) {
                for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                    EquipeVector equipeVector = variante.getEquipeVector();
                    for (int i = 0; i < equipeVector.getSize(); ++i) {
                        String row = equipeVector.getEquipeVector().get(i).toCSV(variante.getName());
                        writer.write(row);
                        writer.write(System.lineSeparator());
                    }
                }
            }
        }
        catch (IOException e) {
            DesktopView.beep();
            ErrorPane.showMessageDialog(GeRaidV3.getRootFrame(), L10n.getString(ERROR_FILE_WRITING, e.getClass().getName(), e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    static List<String> _readPucesFromFile(String puceFile) throws IOException, BadFileContent {
        ArrayList<String> puces = new ArrayList<String>();
        try (BufferedReader fileReader = new BufferedReader(new FileReader(puceFile, StandardCharsets.UTF_8));){
            String line = fileReader.readLine();
            int lineNumber = 0;
            String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            while ((line = fileReader.readLine()) != null) {
                ++lineNumber;
                String[] row = line.trim().split(delimiter);
                if (row.length == 0) {
                    throw new BadFileContent(L10n.getString(ERROR_FORMAT, puceFile));
                }
                String puce = row[0];
                if (puce.isEmpty()) {
                    throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.puce_vide", lineNumber));
                }
                if (puces.contains(puce)) {
                    throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.puce_double", lineNumber, puce));
                }
                try {
                    Integer.parseInt(puce);
                    puces.add(puce);
                }
                catch (NumberFormatException e) {
                    throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.puce_format", lineNumber, puce));
                    return puces;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(L10n.getString(ERROR_FIND, puceFile));
        }
        catch (IOException e) {
            throw new IOException(L10n.getString(ERROR_READ, puceFile));
        }
    }

    @VisibleForTesting
    static Map<ParcoursVariante, List<Equipe>> _readEquipesFromFile(Raid raid, String equipeFile) throws IOException, BadFileContent {
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        LinkedHashMap<ParcoursVariante, List<Equipe>> equipesInVariante = new LinkedHashMap<ParcoursVariante, List<Equipe>>();
        ParcoursVector parcoursVector = raid.getParcoursVector();
        try (BufferedReader file = new BufferedReader(new FileReader(equipeFile));){
            String line = file.readLine();
            int lineNumber = 1;
            String delimiter = FileUtils.extractDelimiterFromCsvHeader(line);
            if (!delimiter.equals(";")) {
                throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.delimiter_error"));
            }
            while ((line = file.readLine()) != null) {
                ++lineNumber;
                String[] row = line.trim().split(delimiter);
                if (row.length == 0) continue;
                if (row.length <= 5) {
                    throw new BadFileContent(L10n.getString(ERROR_FORMAT, equipeFile));
                }
                if (row[0].isEmpty()) {
                    throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.dossard_null", lineNumber));
                }
                if (row[1].isEmpty()) {
                    throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.equipe_name_null", lineNumber));
                }
                ParcoursVariante variante = CsvEquipeHelper._getVarianteFromName(parcoursVector, row[4], lineNumber);
                equipesInVariante.putIfAbsent(variante, new ArrayList());
                CsvEquipeHelper._assignEquipeToParcours(raid, pucesSpecificationsHandler, variante, row, equipesInVariante, lineNumber);
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(L10n.getString(ERROR_FIND, equipeFile));
        }
        catch (IOException e) {
            throw new IOException(L10n.getString(ERROR_READ, equipeFile));
        }
        return equipesInVariante;
    }

    private static void _assignEquipeToParcours(Map<ParcoursVariante, List<Equipe>> equipeInParcours) {
        ParcoursVariante variante;
        LinkedHashMap<ParcoursVariante, List> newEquipes = new LinkedHashMap<ParcoursVariante, List>();
        for (Map.Entry<ParcoursVariante, List<Equipe>> entry : equipeInParcours.entrySet()) {
            variante = entry.getKey();
            List<Equipe> equipes = entry.getValue();
            for (Equipe equipe : equipes) {
                newEquipes.computeIfAbsent(variante, v -> new ArrayList()).add(equipe);
            }
        }
        for (Map.Entry<ParcoursVariante, List<Equipe>> entry : newEquipes.entrySet()) {
            variante = entry.getKey();
            for (Equipe equipe : entry.getValue()) {
                variante.getEquipeVector().addEquipeIfNotExistSameBibAndName(equipe);
            }
        }
    }

    private static int _addVacantEquipesToParcours(Raid raid, int numberOfEquipes, ParcoursVariante variante, List<String> puces, int maxNumberOfPucesPerEquipe, int currentPuce, Map<ParcoursVariante, List<Equipe>> newEquipes) throws BadFileContent {
        int bib = NumberUtils.parseInt(variante.getEquipeVector().getMaxBibNumber(), 500);
        StringBuilder errorMessage = new StringBuilder();
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        if (maxNumberOfPucesPerEquipe == 0) {
            maxNumberOfPucesPerEquipe = 1;
        }
        for (int i = 0; i < numberOfEquipes; ++i) {
            Equipe equipe = new Equipe(raid.getPuceResultVector());
            equipe.setName("Vacant-" + i);
            equipe.setBib("v-" + bib++);
            equipe.setCategorie(raid.getCategorieVector().getCategorieVector().get(0));
            for (int j = 0; j < maxNumberOfPucesPerEquipe; ++j) {
                String puce;
                if (currentPuce >= puces.size()) {
                    throw new BadFileContent(L10n.getString(NOT_ENOUGH_PUCE));
                }
                if (pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce = puces.get(currentPuce++), variante, errorMessage)) {
                    throw new BadFileContent(L10n.getString(ERROR_MEMORY, puce, variante.getName()));
                }
                equipe.addPuceId(puce);
            }
            newEquipes.computeIfAbsent(variante, v -> new ArrayList()).add(equipe);
        }
        return currentPuce;
    }

    private static List<String> _assignPuceIds(int puceCount, int currentPuceIndex, List<String> puces, ParcoursVariante variante) throws BadFileContent {
        ArrayList<String> pucesIds = new ArrayList<String>();
        StringBuilder errorMessage = new StringBuilder();
        PucesSpecificationsHandler pucesSpecificationsHandler = new PucesSpecificationsHandler();
        while (puceCount > 0) {
            String puce;
            if (currentPuceIndex >= puces.size()) {
                throw new BadFileContent(L10n.getString(NOT_ENOUGH_PUCE));
            }
            if (pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puce = puces.get(currentPuceIndex++), variante, errorMessage)) {
                throw new BadFileContent(L10n.getString(ERROR_MEMORY, puce, variante.getName()));
            }
            pucesIds.add(puce);
            --puceCount;
        }
        return pucesIds;
    }

    private static void _assignPucesToParcours(Raid raid, Map<ParcoursVariante, List<Equipe>> equipeInParcours, List<String> puces, Map<String, Integer> vacantEquipeParcours, int maxNumberOfPucesPerEquipe) throws BadFileContent {
        ParcoursVariante variante;
        LinkedHashMap<ParcoursVariante, List<Equipe>> newEquipes = new LinkedHashMap<ParcoursVariante, List<Equipe>>();
        int currentPuceIndex = 0;
        for (Map.Entry<ParcoursVariante, List<Equipe>> entry : equipeInParcours.entrySet()) {
            variante = entry.getKey();
            List<Equipe> equipes = entry.getValue();
            if (equipes.size() > puces.size()) {
                throw new BadFileContent(L10n.getString(NOT_ENOUGH_PUCE));
            }
            for (Equipe equipe : equipes) {
                int numberOfEquipiers = equipe.getEquipierVector().getSize();
                int numberOfPucesToAssign = maxNumberOfPucesPerEquipe == 0 ? numberOfEquipiers : Math.min(numberOfEquipiers, maxNumberOfPucesPerEquipe);
                if ((numberOfPucesToAssign -= equipe.getPuceCount()) > 0) {
                    List<String> puceIds = CsvEquipeHelper._assignPuceIds(numberOfPucesToAssign, currentPuceIndex, puces, variante);
                    puceIds.forEach(equipe::addPuceId);
                    currentPuceIndex += numberOfPucesToAssign;
                }
                newEquipes.computeIfAbsent(variante, v -> new ArrayList()).add(equipe);
            }
            currentPuceIndex = CsvEquipeHelper._addVacantEquipesToParcours(raid, vacantEquipeParcours.get(variante.getName()), variante, puces, maxNumberOfPucesPerEquipe, currentPuceIndex, newEquipes);
        }
        for (Map.Entry<ParcoursVariante, List<Equipe>> entry : newEquipes.entrySet()) {
            variante = entry.getKey();
            for (Equipe equipe : entry.getValue()) {
                variante.getEquipeVector().addEquipeIfNotExistSameBibAndName(equipe);
            }
        }
    }

    private static void _assignEquipeToParcours(Raid raid, PucesSpecificationsHandler pucesSpecificationsHandler, ParcoursVariante variante, String[] row, Map<ParcoursVariante, List<Equipe>> equipesInParcours, int lineNumber) throws BadFileContent {
        Equipe equipe = new Equipe(raid.getPuceResultVector());
        equipe.setBib(row[0]);
        equipe.setName(row[1]);
        String puces = row[2].trim();
        if (!puces.isEmpty()) {
            equipe.setPuceIds(puces);
            for (String puceId : equipe.getPuceIds()) {
                StringBuilder errorMessage;
                if (!pucesSpecificationsHandler.isPuceIncompatibleWithParcours(puceId, variante, errorMessage = new StringBuilder())) continue;
                throw new BadFileContent(L10n.getString(ERROR_MEMORY, puceId, variante.getName()));
            }
        }
        equipe.setPhone(row[5]);
        if (raid.notExistsCategorieWithShortName(row[3])) {
            throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.invalid_category", lineNumber, row[3]));
        }
        equipe.setCategorie(raid.getCategorieVector().getCategorieFromShortName(row[3]));
        int equipierCount = 1;
        int numberOfEquipiers = (row.length - 6) / 2;
        for (int i = 0; i < numberOfEquipiers; ++i) {
            int lastnameColumn = 6 + i * 2;
            int firstnameColumn = lastnameColumn + 1;
            if (row[lastnameColumn].isEmpty() && row[firstnameColumn].isEmpty()) continue;
            equipe.getEquipierVector().addEquipier(new Equipier(row[lastnameColumn], row[firstnameColumn]));
            if (i + 1 <= equipierCount) continue;
            ++equipierCount;
        }
        equipesInParcours.get(variante).add(equipe);
    }

    private static ParcoursVariante _getVarianteFromName(ParcoursVector parcoursVector, String parcoursName, int lineNumber) throws BadFileContent {
        ParcoursVariante variante = parcoursVector.getVarianteParcoursFromNameWithoutDiacritic(parcoursName);
        if (variante == null) {
            Parcours parcours = parcoursVector.getParcoursFromNameWithoutDiacritic(parcoursName);
            if (parcours == null) {
                throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.parcours_null", lineNumber));
            }
            if (parcours.getVarianteVector().getSize() == 0) {
                throw new BadFileContent(L10n.getString("csv_equipe_helper.specific_error.parcours_empty", lineNumber, parcoursName));
            }
            variante = parcours.getVarianteVector().getVarianteParcoursVector().firstElement();
        }
        return variante;
    }
}

