/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.equipe;

import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.equipe.EquipierVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.PuceResultVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Equipe {
    private final PuceResultVector _puceResultVector;
    private final List<String> _puceIds = new ArrayList<String>();
    private EquipierVector _equipierVector = new EquipierVector();
    private Categorie _categorie;
    private String _name = "";
    private String _bib = "";
    private String _phone = "";
    private boolean _notClassified;
    private boolean _absent;

    public Equipe(PuceResultVector puceResultVector) {
        this._puceResultVector = puceResultVector;
    }

    public boolean isAbsent() {
        return this._absent;
    }

    public void setAbsent(boolean value) {
        this._absent = value;
    }

    public boolean isNotClassified() {
        return this._notClassified;
    }

    public void setNotClassified(boolean notClassified) {
        this._notClassified = notClassified;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPhone() {
        return this._phone;
    }

    public void setPhone(String number) {
        this._phone = number;
    }

    public Categorie getCategorie() {
        return this._categorie;
    }

    public void setCategorie(Categorie categorie) {
        this._categorie = categorie;
    }

    public String getBib() {
        return this._bib;
    }

    public void setBib(String bib) {
        this._bib = bib;
    }

    public boolean isArrived(Parcours parcours, Etape etape) {
        return this._puceResultVector.isArrived(this, parcours, etape);
    }

    public PuceResultVector getPuceResultVector() {
        return this._puceResultVector;
    }

    public int getPuceCount() {
        return this._puceIds.size();
    }

    public List<String> getPuceIds() {
        return this._puceIds;
    }

    public void setPuceIds(String pucesIdsString) {
        String[] puceIds = pucesIdsString.trim().split(",");
        this._puceIds.clear();
        List<String> array = Arrays.asList(puceIds);
        array.replaceAll(String::trim);
        this._puceIds.addAll(Arrays.asList(puceIds));
    }

    public void removePuceResult() {
        this._puceResultVector.removePuceResultForEquipe(this);
    }

    public String getPuceIdsAsString() {
        StringBuilder result = new StringBuilder();
        for (String puceId : this._puceIds) {
            result.append(puceId).append(",");
        }
        int index = result.lastIndexOf(",");
        if (index != -1) {
            result.delete(index, index + 1);
        }
        return result.toString();
    }

    public void addPuceId(String puceId) {
        this._puceIds.add(puceId);
    }

    public boolean containsPuceId(String puceId) {
        return this._puceIds.contains(puceId);
    }

    public EquipierVector getEquipierVector() {
        return this._equipierVector;
    }

    public void setEquipierVector(EquipierVector equipierVector) {
        this._equipierVector = equipierVector;
    }

    public String getEquipierNames() {
        StringBuilder text = new StringBuilder();
        List<Equipier> equipierVector = this._equipierVector.getEquipierVector();
        boolean first = true;
        for (Equipier equipier : equipierVector) {
            if (!first) {
                text.append("\n");
            }
            first = false;
            text.append(equipier.getLastname());
            text.append(" ");
            text.append(equipier.getFirstname());
        }
        return text.toString();
    }

    public boolean containsEquipier(String partOfLowercaseEquipierName) {
        return this.getEquipierNames().toLowerCase().contains(partOfLowercaseEquipierName);
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.getBib() + " ");
        string.append(this.getName());
        string.append(" (").append(this.getPuceIdsAsString()).append(")");
        if (this.getCategorie() != null) {
            string.append(" ").append(this.getCategorie().getShortName());
        }
        if (this.isNotClassified()) {
            string.append(" NC");
        }
        if (this.isAbsent()) {
            string.append(" (ABS)");
        }
        return string.toString();
    }

    public String toCSV(String parcoursName) {
        StringBuilder csvText = new StringBuilder();
        List<Equipier> equipierVector = this.getEquipierVector().getEquipierVector();
        csvText.append(this.getBib()).append(";").append(this.getName()).append(";").append(this.getPuceIdsAsString()).append(";").append(this.getCategorie().getShortName()).append(";").append(parcoursName).append(";").append(this.getPhone());
        for (Equipier equipier : equipierVector) {
            csvText.append(";").append(equipier.getLastname()).append(";").append(equipier.getFirstname());
        }
        return csvText.toString();
    }
}

