/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.etape;

import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.StartType;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.Date;
import org.jetbrains.annotations.VisibleForTesting;

public final class Etape {
    private String _name = "";
    private boolean _finished = false;
    private StartType _startType = StartType.GROUPE;
    private Date _startHour = new Date(32400000L);
    private LimitType _limitType = LimitType.SANSLIMITE;
    private Date _limitHour = new Date(0L);
    private Date _durationLimit = new Date(0L);
    private int _penaltyInterval = 5;
    private int _penaltyPoints = 0;
    private int _penaltyTimeInMm = 0;
    private boolean _isGelUsedInTimeLimit = false;

    public Etape() {
    }

    @VisibleForTesting
    public Etape(String name) {
        this._name = name;
    }

    Etape(Etape etape) {
        this._name = etape._name;
        this._finished = etape._finished;
        this._startType = etape._startType;
        this._startHour = (Date)etape._startHour.clone();
        this._limitType = etape._limitType;
        this._limitHour = (Date)etape._limitHour.clone();
        this._durationLimit = (Date)etape._durationLimit.clone();
        this._penaltyInterval = etape._penaltyInterval;
        this._penaltyPoints = etape._penaltyPoints;
        this._penaltyTimeInMm = etape._penaltyTimeInMm;
        this._isGelUsedInTimeLimit = etape._isGelUsedInTimeLimit;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public StartType getStartType() {
        return this._startType;
    }

    public void setStartType(StartType startType) {
        this._startType = startType;
    }

    public Date getStartHour() {
        return this._startHour;
    }

    public void setStartHour(Date startHour) {
        this._startHour = startHour;
    }

    public int getPenaltyTimeInMm() {
        return this._penaltyTimeInMm;
    }

    public void setPenaltyTimeInMm(int penaltyTimeInMn) {
        this._penaltyTimeInMm = penaltyTimeInMn;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this._name);
        if (this._finished) {
            result.append(" (termin\u00e9)");
        } else {
            result.append(" (en cours)");
        }
        return result.toString();
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void setFinished(boolean finished) {
        this._finished = finished;
    }

    public String getFinishedAsString() {
        return this.isFinished() ? "1" : "0";
    }

    public LimitType getLimitType() {
        return this._limitType;
    }

    public void setLimitType(LimitType limitType) {
        this._limitType = limitType;
    }

    public Date getLimitHour() {
        return this._limitHour;
    }

    public void setLimitHour(Date limitHour) {
        this._limitHour = limitHour;
    }

    public Date getDurationLimit() {
        return this._durationLimit;
    }

    public void setDurationLimit(Date durationLimit) {
        this._durationLimit = durationLimit;
    }

    public int getPenaltyInterval() {
        return this._penaltyInterval;
    }

    public void setPenaltyInterval(int penaltyInterval) {
        this._penaltyInterval = penaltyInterval;
    }

    public int getPenaltyPoints() {
        return this._penaltyPoints;
    }

    public void setPenaltyPoints(int penalty) {
        this._penaltyPoints = penalty;
    }

    public String getGelUsedInTimeLimit() {
        return this.isGelUsedInTimeLimit() ? "1" : "0";
    }

    public boolean isGelUsedInTimeLimit() {
        return this._isGelUsedInTimeLimit;
    }

    public void setGelUsedInTimeLimit(boolean gelUsedInTimeLimit) {
        this._isGelUsedInTimeLimit = gelUsedInTimeLimit;
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder();
        html.append("<b>\u00c9tape : ").append(this._name).append("</b><br>");
        html.append("D\u00e9part : ").append(this._startType.toString());
        if (this._startType == StartType.GROUPE) {
            html.append(" \u00e0 ").append(DateTimeUtils.dateToString(this._startHour));
        }
        html.append("<br>");
        switch (this._limitType) {
            case SANSLIMITE: {
                html.append("Sans limite de temps");
                break;
            }
            case AVECLIMITETEMPS: {
                html.append("Avec limite de dur\u00e9e \u00e0 ").append(DateTimeUtils.dateToString(this._durationLimit)).append(" et p\u00e9nalit\u00e9 de ").append(this._penaltyPoints).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this._penaltyTimeInMm * 60000L)).append(" par ").append(this._penaltyInterval).append(" mn de d\u00e9passement.");
                break;
            }
            case AVECLIMITEHORAIRE: {
                html.append("Avec limite horaire \u00e0 ").append(DateTimeUtils.dateToString(this._limitHour)).append(" et p\u00e9nalit\u00e9 de ").append(this._penaltyPoints).append(" points et ").append(DateTimeUtils.millisecondsToString((long)this._penaltyTimeInMm * 60000L)).append(" par ").append(this._penaltyInterval).append(" mn de d\u00e9passement.");
                break;
            }
        }
        return html.toString();
    }

    public EpreuveVector getEpreuvesBetween(Parcours parcours, ParcoursVariante variante) {
        if (variante != null) {
            return variante.getEpreuvesOfEtape(this);
        }
        if (parcours != null) {
            return parcours.getEpreuvesOfEtape(this);
        }
        return null;
    }
}

