/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.etape;

import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.etape.Etape;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public final class EtapeEpreuveMap {
    final Map<Etape, EpreuveVector> _etapeEpreuveMap = new LinkedHashMap<Etape, EpreuveVector>();

    public EtapeEpreuveMap createVariante() {
        EtapeEpreuveMap varianteMap = new EtapeEpreuveMap();
        for (Map.Entry<Etape, EpreuveVector> entry : this._etapeEpreuveMap.entrySet()) {
            varianteMap.addEtape(entry.getKey());
            varianteMap.setEpreuvesOfEtape(entry.getKey(), entry.getValue().createVariante());
        }
        return varianteMap;
    }

    public Vector<Etape> getEtapeVector() {
        return new Vector<Etape>(this._etapeEpreuveMap.keySet());
    }

    public EpreuveVector getEpreuvesOfEtape(Etape etape) {
        return this._etapeEpreuveMap.get(etape);
    }

    public void setEpreuvesOfEtape(Etape etape, EpreuveVector epreuveVector) {
        this._etapeEpreuveMap.replace(etape, epreuveVector);
    }

    public void addEtape(Etape etape) {
        if (!this.existsAnotherEtapeWithSameName(etape.getName(), etape)) {
            this._etapeEpreuveMap.putIfAbsent(etape, new EpreuveVector());
        }
    }

    public void removeEtape(Etape etape) {
        this._etapeEpreuveMap.remove(etape);
    }

    public int getSize() {
        return this._etapeEpreuveMap.size();
    }

    public boolean existsAnotherEtapeWithSameName(String name, Etape etape) {
        String trimmedUpperCase = name.trim().toUpperCase();
        for (Etape etape1 : this._etapeEpreuveMap.keySet()) {
            if (etape1 == etape || !etape1.getName().toUpperCase().equals(trimmedUpperCase)) continue;
            return true;
        }
        return false;
    }

    public int getTotalPoints(Etape etape) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        return epreuveVector.getTotalPoints();
    }

    public int getFirstCodeOfNextEpreuve(Etape etape, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        for (int i = 0; i < epreuveVector.getSize() - 1; ++i) {
            if (epreuveVector.getEpreuveVector().get(i) != epreuve) continue;
            return epreuveVector.getEpreuveVector().get(i + 1).getBaliseVector().getFirstBaliseNumber();
        }
        return 0;
    }

    public int getLastCodeOfPreviousEpreuve(Etape etape, Epreuve epreuve) {
        Vector<Epreuve> epreuveVector = this._etapeEpreuveMap.get(etape).getEpreuveVector();
        for (int i = 1; i < epreuveVector.size(); ++i) {
            if (epreuveVector.get(i) != epreuve) continue;
            Epreuve previousEpreuve = epreuveVector.get(i - 1);
            if (previousEpreuve.isBackAndForth()) {
                return previousEpreuve.getBaliseVector().getFirstBaliseNumber();
            }
            return previousEpreuve.getBaliseVector().getLastBaliseNumber();
        }
        return 0;
    }

    public BaliseVector getBalisesOfNextEpreuve(Etape etape, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        for (int i = 0; i < epreuveVector.getSize() - 1; ++i) {
            if (epreuveVector.getEpreuveVector().get(i) != epreuve) continue;
            return epreuveVector.getEpreuveVector().get(i + 1).getBaliseVector();
        }
        return null;
    }

    public BaliseVector getBalisesOfPreviousEpreuve(Etape etape, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        for (int i = 1; i < epreuveVector.getSize(); ++i) {
            if (epreuveVector.getEpreuveVector().get(i) != epreuve) continue;
            return epreuveVector.getEpreuveVector().get(i - 1).getBaliseVector();
        }
        return null;
    }

    public boolean existsEpreuveName(Etape etape, String name) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        return epreuveVector.existsWithSameName(name);
    }

    public boolean existsAnotherEpreuveWithSameName(Etape etape, String name, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        return epreuveVector.existsWithSameName(name, epreuve);
    }

    public boolean existsEtape(Etape etape) {
        return this._etapeEpreuveMap.containsKey(etape);
    }

    public Etape getEtapeFromName(String name) {
        for (Etape etape : this.getEtapeVector()) {
            if (!etape.getName().equals(name)) continue;
            return etape;
        }
        return null;
    }

    public Etape getCurrentEtape() {
        for (Etape etape : this.getEtapeVector()) {
            if (etape.isFinished()) continue;
            return etape;
        }
        return null;
    }

    public boolean existsEpreuve(Epreuve epreuve) {
        for (EpreuveVector epreuveVector : this._etapeEpreuveMap.values()) {
            if (!epreuveVector.existsEpreuve(epreuve)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstEpreuveOfEtape(Etape etape, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        if (epreuveVector.getEpreuveVector().isEmpty()) {
            return false;
        }
        return epreuveVector.getEpreuveVector().get(0) == epreuve;
    }

    public boolean isLastEpreuve(Etape etape, Epreuve epreuve) {
        EpreuveVector epreuveVector = this._etapeEpreuveMap.get(etape);
        for (int i = 0; i < epreuveVector.getSize(); ++i) {
            if (epreuveVector.getEpreuveVector().get(i) != epreuve || !(i + 1 < epreuveVector.getSize() ? epreuveVector.getEpreuveVector().get(i + 1).isToBeDoneAfterFinish() : i + 1 == epreuveVector.getSize())) continue;
            return true;
        }
        return false;
    }

    public void cloneEpreuves(EtapeEpreuveMap otherMap) {
        ArrayList<Map.Entry<Etape, EpreuveVector>> list = new ArrayList<Map.Entry<Etape, EpreuveVector>>(this._etapeEpreuveMap.entrySet());
        for (Map.Entry<Etape, EpreuveVector> entry : list) {
            Etape etape = entry.getKey();
            EpreuveVector epreuves = entry.getValue();
            Etape etapeParcours = otherMap.getEtapeFromName(etape.getName());
            if (etapeParcours == null) continue;
            EpreuveVector epreuvesParcours = otherMap.getEpreuvesOfEtape(etapeParcours);
            epreuves.cloneEpreuves(epreuvesParcours);
            this._etapeEpreuveMap.put(etapeParcours, epreuves);
        }
        for (Etape etape : this.getEtapeVector()) {
            if (otherMap.existsEtape(etape)) continue;
            this._etapeEpreuveMap.remove(etape);
        }
    }

    public void replaceBalise(int oldCode, int newCode) {
        for (EpreuveVector epreuves : this._etapeEpreuveMap.values()) {
            epreuves.replaceBalise(oldCode, newCode);
        }
    }

    public EtapeEpreuveMap deepCopy() {
        EtapeEpreuveMap etapeEpreuveMap = new EtapeEpreuveMap();
        for (Map.Entry<Etape, EpreuveVector> entry : this._etapeEpreuveMap.entrySet()) {
            Etape etape = entry.getKey();
            etapeEpreuveMap._etapeEpreuveMap.put(new Etape(etape), new EpreuveVector(entry.getValue()));
        }
        return etapeEpreuveMap;
    }

    public EtapeEpreuveMap shallowCopy() {
        EtapeEpreuveMap etapeEpreuveMap = new EtapeEpreuveMap();
        for (Map.Entry<Etape, EpreuveVector> entry : this._etapeEpreuveMap.entrySet()) {
            Etape etape = entry.getKey();
            etapeEpreuveMap._etapeEpreuveMap.put(etape, new EpreuveVector(entry.getValue()));
        }
        return etapeEpreuveMap;
    }
}

