/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.parcours;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.EquipeVector;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public final class ParcoursVariante {
    private EtapeEpreuveMap _etapeEpreuveMap;
    private EquipeVector _equipeVector = new EquipeVector();
    private String _name;

    public ParcoursVariante(String name) {
        this._name = name;
        this._etapeEpreuveMap = new EtapeEpreuveMap();
    }

    public ParcoursVariante(ParcoursVariante variante) {
        long timeInMilliseconds = DateTimeUtils.getLocaleDateInMs();
        this._name = variante._name + "-" + timeInMilliseconds;
        this._equipeVector = new EquipeVector();
        this._etapeEpreuveMap = variante._etapeEpreuveMap.shallowCopy();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public EquipeVector getEquipeVector() {
        return this._equipeVector;
    }

    public void setEquipeVector(EquipeVector equipeVector) {
        this._equipeVector = equipeVector;
    }

    public List<Etape> getEtapeVector() {
        return this._etapeEpreuveMap.getEtapeVector();
    }

    public EtapeEpreuveMap getEtapeEpreuveMap() {
        return this._etapeEpreuveMap;
    }

    public void setEtapeEpreuveMap(EtapeEpreuveMap etapeEpreuveMap) {
        this._etapeEpreuveMap = etapeEpreuveMap;
    }

    public String toString() {
        return this._name;
    }

    public void addEtape(Etape etape) {
        this._etapeEpreuveMap.addEtape(etape);
    }

    public void removeEtape(Etape etape) {
        this._etapeEpreuveMap.removeEtape(etape);
    }

    @VisibleForTesting
    public Etape getEtape(String name) {
        return this._etapeEpreuveMap.getEtapeFromName(name);
    }

    public Etape getCurrentEtape() {
        return this._etapeEpreuveMap.getCurrentEtape();
    }

    public int getNumberOfEquipes() {
        return this._equipeVector.getSize();
    }

    public int getNumberOfEquipesPresent() {
        int count = 0;
        for (int i = 0; i < this._equipeVector.getSize(); ++i) {
            if (this._equipeVector.getEquipeVector().get(i).isAbsent()) continue;
            ++count;
        }
        return count;
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        return this._equipeVector.getEquipeFromPuceId(puceId);
    }

    public void transferEquipe(Equipe equipe) {
        this._equipeVector.addEquipeIfNotExistWithSamePuceAndBib(equipe);
    }

    public EpreuveVector getEpreuvesOfEtape(Etape etape) {
        return this._etapeEpreuveMap.getEpreuvesOfEtape(etape);
    }

    public boolean existsEpreuveName(Etape etape, String string) {
        return this._etapeEpreuveMap.existsEpreuveName(etape, string);
    }

    public void addEpreuveToEtape(Etape etape, Epreuve epreuve) {
        this._etapeEpreuveMap.getEpreuvesOfEtape(etape).addEpreuve(epreuve);
    }

    public boolean existsEquipe(Equipe equipe) {
        return this._equipeVector.existsEquipe(equipe);
    }

    public void removeEpreuveToEtape(Etape etape, Epreuve epreuve) {
        this._etapeEpreuveMap.getEpreuvesOfEtape(etape).removeEpreuve(epreuve);
    }

    public void dissociateEpreuve(Etape etape, Epreuve epreuve) {
        this._etapeEpreuveMap.getEpreuvesOfEtape(etape).replaceEpreuve(epreuve, epreuve.getFactory().createEpreuve(epreuve));
    }

    public void cloneEpreuves(EtapeEpreuveMap etapeEpreuveMapParcours) {
        this._etapeEpreuveMap.cloneEpreuves(etapeEpreuveMapParcours);
    }

    public void replaceBalise(int oldCode, int newCode) {
        this._etapeEpreuveMap.replaceBalise(oldCode, newCode);
    }

    public String toHtml(Etape etape) {
        return this._etapeEpreuveMap.getEpreuvesOfEtape(etape).toHtml();
    }

    boolean existsPuceId(String puceId, Equipe equipe) {
        return this._equipeVector.existsPuceFor(puceId, equipe);
    }

    boolean existsPuceId(String puceId) {
        return this._equipeVector.existsPuceFor(puceId);
    }

    boolean existsEpreuve(Epreuve epreuve) {
        return this._etapeEpreuveMap.existsEpreuve(epreuve);
    }

    boolean existsEtape(Etape etape) {
        return this._etapeEpreuveMap.existsEtape(etape);
    }

    boolean containsEquipe(Equipe equipe) {
        return this._equipeVector.getEquipeVector().contains(equipe);
    }
}

