/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.model.parcours;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.utils.DiacriticUtils;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

public final class ParcoursVector {
    private final Vector<Parcours> _parcoursVector = new Vector();

    public Vector<Parcours> getParcoursVector() {
        return this._parcoursVector;
    }

    public void addParcours(Parcours parcours) {
        if (this._notExistsWithSameName(parcours.getName())) {
            this._parcoursVector.add(parcours);
        }
    }

    public Parcours getParcoursFromName(String name) {
        for (Parcours parcours : this._parcoursVector) {
            if (!parcours.getName().equals(name)) continue;
            return parcours;
        }
        return null;
    }

    public Parcours getParcoursFromNameWithoutDiacritic(String name) {
        String nameWithoutDiacritic = DiacriticUtils.removeDiacritic(name);
        for (Parcours parcours : this._parcoursVector) {
            String parcoursNameWithoutDiacritic = DiacriticUtils.removeDiacritic(parcours.getName());
            if (!parcoursNameWithoutDiacritic.equals(nameWithoutDiacritic)) continue;
            return parcours;
        }
        return null;
    }

    public int getSize() {
        return this._parcoursVector.size();
    }

    public String getNameAtIndex(int index) {
        return this._parcoursVector.get(index).getName();
    }

    public Parcours getParcoursOfEquipe(Equipe equipe) {
        for (Parcours parcours : this._parcoursVector) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                if (!variante.containsEquipe(equipe)) continue;
                return parcours;
            }
        }
        return null;
    }

    public String toHtml() {
        StringBuilder string = new StringBuilder();
        for (Parcours parcours : this._parcoursVector) {
            string.append(parcours.toHtml());
        }
        return string.toString();
    }

    public boolean existsAnotherParcoursWithSameName(String name, Parcours parcours) {
        String trimmedName = name.trim();
        for (Parcours parcours1 : this._parcoursVector) {
            if (!parcours1.getName().equals(trimmedName) || parcours1 == parcours) continue;
            return true;
        }
        return false;
    }

    public void removeParcours(Parcours parcours) {
        this._parcoursVector.remove(parcours);
    }

    public void clear() {
        this._parcoursVector.clear();
    }

    public boolean addEquipeInParcours(ParcoursVariante variante, Equipe equipe) {
        return variante.getEquipeVector().addEquipeIfNotExistWithSamePuceAndBib(equipe);
    }

    public boolean existsPuceId(String puceId, Equipe equipe) {
        for (Parcours parcours : this._parcoursVector) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                if (!variante.existsPuceId(puceId, equipe)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean existsPuceFromId(String puceId) {
        for (Parcours parcours : this._parcoursVector) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                if (!variante.existsPuceId(puceId)) continue;
                return true;
            }
        }
        return false;
    }

    public Parcours getParcoursFromPuceId(String puceId) {
        for (Parcours parcours : this._parcoursVector) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                if (!variante.existsPuceId(puceId)) continue;
                return parcours;
            }
        }
        return null;
    }

    public Equipe getEquipeFromPuceId(String puceId) {
        for (Parcours parcours : this._parcoursVector) {
            for (ParcoursVariante variante : parcours.getVarianteVector().getVarianteParcoursVector()) {
                Equipe equipe = variante.getEquipeFromPuceId(puceId);
                if (equipe == null) continue;
                return equipe;
            }
        }
        return null;
    }

    public Parcours getParcoursFromEpreuve(Epreuve epreuve) {
        for (Parcours parcours : this._parcoursVector) {
            if (!parcours.existsEpreuve(epreuve)) continue;
            return parcours;
        }
        return null;
    }

    public Parcours getParcoursFromEtape(Etape etape) {
        for (Parcours parcours : this._parcoursVector) {
            if (!parcours.existsEtape(etape)) continue;
            return parcours;
        }
        return null;
    }

    public ParcoursVariante getVarianteParcoursFromNameWithoutDiacritic(String name) {
        for (Parcours parcours : this._parcoursVector) {
            ParcoursVariante variante = parcours.getVarianteVector().getVarianteParcoursFromNameWithoutDiacritic(name);
            if (variante == null) continue;
            return variante;
        }
        return null;
    }

    @VisibleForTesting
    public ParcoursVariante getVarianteParcoursFromName(String name) {
        for (Parcours parcours : this._parcoursVector) {
            ParcoursVariante variante = parcours.getVarianteVector().getVarianteParcoursFromName(name);
            if (variante == null) continue;
            return variante;
        }
        return null;
    }

    public boolean existsAnotherVarianteWithSameName(String varianteName, ParcoursVariante variante) {
        for (Parcours parcours : this._parcoursVector) {
            boolean isVarianteWithSameName = parcours.existsAnotherVarianteWithSameName(varianteName, variante);
            if (!isVarianteWithSameName) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean _notExistsWithSameName(String name) {
        String trimmedName = name.trim().toLowerCase();
        for (Parcours parcours : this._parcoursVector) {
            if (!parcours.getName().toLowerCase().equals(trimmedName)) continue;
            return false;
        }
        return true;
    }
}

