/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.BaliseValidationState;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public final class BaliseValidationStateVector {
    private final List<BaliseValidationState> _stateVector = new ArrayList<BaliseValidationState>();
    private Map<Integer, List<Date>> _extraCodes = new HashMap<Integer, List<Date>>();

    public List<BaliseValidationState> getStateVector() {
        return this._stateVector;
    }

    public void setExtraCodes(Map<Integer, List<Date>> extraCodes) {
        this._extraCodes = extraCodes;
    }

    public void add(int[] codes, boolean[] validationState, long[] punchTimesInMs) {
        for (int i = 0; i < codes.length; ++i) {
            this._stateVector.add(new BaliseValidationState(codes[i], validationState[i], punchTimesInMs[i]));
        }
    }

    public String toHtml() {
        StringBuilder html = new StringBuilder("<html><body>");
        int pmCount = this._getNumberOfMispunchCodes(this._stateVector);
        if (pmCount > 0) {
            html.append("<font color=red> ").append(pmCount).append(" PM : </font>");
        }
        if (!this._stateVector.getLast().isValidated()) {
            html.append("<font color=red>  AAA </font>");
        }
        for (BaliseValidationState codeValidationState : this._stateVector) {
            Object code = codeValidationState.getCode() == 16 ? "D" : (codeValidationState.getCode() == 15 ? "A" : "" + codeValidationState.getCode());
            if (codeValidationState.isValidated()) {
                html.append("<font color=green> ").append((String)code).append(" </font>");
                continue;
            }
            html.append("<font color=red> ").append((String)code).append(" </font>");
        }
        html.append("<br>");
        html.append(BaliseValidationStateVector._generateExtraCodesHtml(this._extraCodes));
        html.append("</body></html>");
        return html.toString();
    }

    @VisibleForTesting
    int _getNumberOfMispunchCodes(List<BaliseValidationState> stateVector) {
        int counter = 0;
        for (BaliseValidationState baliseValidationState : stateVector) {
            if (baliseValidationState.isValidated()) continue;
            ++counter;
        }
        return counter;
    }

    @VisibleForTesting
    static String _generateExtraCodesHtml(Map<Integer, List<Date>> extraCodes) {
        StringBuilder html = new StringBuilder();
        if (!extraCodes.isEmpty()) {
            html.append("<font color=blue> Codes en plus : ");
            for (Map.Entry<Integer, List<Date>> entry : extraCodes.entrySet()) {
                int extraCode = entry.getKey();
                List<Date> timesOfExtraCode = entry.getValue();
                for (Date timeOfExtraCode : timesOfExtraCode) {
                    html.append(" ").append(extraCode).append(" - ").append(DateTimeUtils.dateToString(timeOfExtraCode)).append(" /");
                }
            }
            html.deleteCharAt(html.length() - 1);
            html.append("</font>");
        }
        return html.toString();
    }
}

