/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.List;

final class EpreuveAuScoreStrategy
implements IPunchValidatorStrategy {
    private final List<Integer> _allPunchedBaliseCodes;
    private final List<Long> _allBalisePunchTimesInMs;
    private final int[] _epreuveBaliseCodes;
    private boolean[] _punchStates;
    private long[] _punchTimesInMs;

    EpreuveAuScoreStrategy(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes, List<Long> allBalisePunchTimesInMs) {
        this._epreuveBaliseCodes = epreuveBaliseCodes;
        this._allPunchedBaliseCodes = allPunchedBaliseCodes;
        this._allBalisePunchTimesInMs = allBalisePunchTimesInMs;
        this._computeBalisePunchStatesAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchStates;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    private void _computeBalisePunchStatesAndPunchTimes() {
        boolean[] areBalisesAlreadyUsed = new boolean[this._allPunchedBaliseCodes.size()];
        this._punchStates = new boolean[this._epreuveBaliseCodes.length];
        this._punchTimesInMs = new long[this._epreuveBaliseCodes.length];
        for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
            int index = this._getIndexOfUnusedCode(this._epreuveBaliseCodes[i], areBalisesAlreadyUsed);
            if (index >= 0) {
                this._punchStates[i] = true;
                this._punchTimesInMs[i] = this._allBalisePunchTimesInMs.get(index);
                continue;
            }
            this._punchStates[i] = false;
            this._punchTimesInMs[i] = -1L;
        }
    }

    private int _getIndexOfUnusedCode(int code, boolean[] areBalisesAlreadyUsed) {
        for (int i = 0; i < this._allPunchedBaliseCodes.size(); ++i) {
            if (code != this._allPunchedBaliseCodes.get(i) || areBalisesAlreadyUsed[i]) continue;
            areBalisesAlreadyUsed[i] = true;
            return i;
        }
        return -1;
    }
}

