/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.Arrays;
import java.util.List;

public final class EpreuveEnAscenseurStrategy
implements IPunchValidatorStrategy {
    private final List<Integer> _allPunchedBaliseCodes;
    private final List<Long> _allBalisePunchTimesInMs;
    private final int[] _epreuveBaliseCodes;
    private final boolean _isBackAndForth;
    private boolean[] _punchState;
    private long[] _punchTimesInMs;

    public EpreuveEnAscenseurStrategy(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes, List<Long> allBalisePunchTimesInMs, boolean isBackAndForth) {
        this._epreuveBaliseCodes = epreuveBaliseCodes;
        this._allPunchedBaliseCodes = allPunchedBaliseCodes;
        this._allBalisePunchTimesInMs = allBalisePunchTimesInMs;
        this._isBackAndForth = isBackAndForth;
        this._computeBalisePunchStatesAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchState;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    private void _computeBalisePunchStatesAndPunchTimes() {
        this._punchState = new boolean[this._epreuveBaliseCodes.length];
        this._punchTimesInMs = new long[this._epreuveBaliseCodes.length];
        if (this._epreuveBaliseCodes.length == 0) {
            return;
        }
        int indexOfFirstBalise = this._findAscenseurSequence(this._isBackAndForth);
        if (indexOfFirstBalise > -1) {
            this._fillResultsWithPVFrom(indexOfFirstBalise);
        } else {
            this._fillResultsWithPM();
        }
    }

    private void _fillResultsWithPVFrom(int indexOfFirstBalise) {
        Arrays.fill(this._punchState, true);
        if (this._epreuveBaliseCodes[0] == this._allPunchedBaliseCodes.get(indexOfFirstBalise)) {
            for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
                this._punchTimesInMs[i] = this._allBalisePunchTimesInMs.get(indexOfFirstBalise + i);
            }
        } else {
            for (int i = 0; i < this._epreuveBaliseCodes.length; ++i) {
                this._punchTimesInMs[this._epreuveBaliseCodes.length - 1 - i] = this._allBalisePunchTimesInMs.get(indexOfFirstBalise + i);
            }
        }
    }

    private void _fillResultsWithPM() {
        Arrays.fill(this._punchState, false);
        Arrays.fill(this._punchTimesInMs, -1L);
    }

    private int _findAscenseurSequence(boolean isBackAndForth) {
        if (isBackAndForth) {
            for (int i = 0; i < this._allPunchedBaliseCodes.size(); ++i) {
                if (this._allPunchedBaliseCodes.get(i) != this._epreuveBaliseCodes[0] || !this._findNaturalOrderSequence(i)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._allPunchedBaliseCodes.size(); ++i) {
                if (this._allPunchedBaliseCodes.get(i) == this._epreuveBaliseCodes[0] && this._findNaturalOrderSequence(i)) {
                    return i;
                }
                if (this._allPunchedBaliseCodes.get(i) != this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1] || !this._findReverseOrderSequence(i)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean _findNaturalOrderSequence(int indexToStart) {
        int index = 1;
        for (int j = 1; indexToStart + j < this._allPunchedBaliseCodes.size() && j < this._epreuveBaliseCodes.length; ++j) {
            if (this._allPunchedBaliseCodes.get(indexToStart + j) == this._epreuveBaliseCodes[j]) {
                ++index;
                continue;
            }
            return false;
        }
        return index == this._epreuveBaliseCodes.length;
    }

    private boolean _findReverseOrderSequence(int indexToStart) {
        int index = 1;
        int j = 1;
        while (indexToStart + j < this._allPunchedBaliseCodes.size() && this._epreuveBaliseCodes.length - 1 - j > -1) {
            if (this._allPunchedBaliseCodes.get(indexToStart + j) == this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1 - j]) {
                ++index;
            } else {
                return false;
            }
            ++j;
        }
        return index == this._epreuveBaliseCodes.length;
    }
}

