/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

final class EpreuveEnLigneStrategy
implements IPunchValidatorStrategy {
    private final int[] _epreuveBaliseCodes;
    private final List<Integer> _allPunchedBaliseCodes;
    private final List<Long> _allBalisePunchTimesInMs;
    private boolean[] _punchState;
    private long[] _punchTimesInMs;

    EpreuveEnLigneStrategy(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes, List<Long> allBalisePunchTimesInMs) {
        this._epreuveBaliseCodes = epreuveBaliseCodes;
        this._allPunchedBaliseCodes = allPunchedBaliseCodes;
        this._allBalisePunchTimesInMs = allBalisePunchTimesInMs;
        this._removeUnexpectedCodesFromPunchedCodes();
        this._computeBalisePunchStatesAndPunchTimes();
    }

    @Override
    public boolean[] getBalisePunchStates() {
        return this._punchState;
    }

    @Override
    public long[] getBalisePunchTimesInMs() {
        return this._punchTimesInMs;
    }

    @VisibleForTesting
    static int _min(int a, int b, int c) {
        if (a <= b && a <= c) {
            return a;
        }
        if (b <= a && b <= c) {
            return b;
        }
        return c;
    }

    @VisibleForTesting
    static boolean[] _computeBalisePunchStates(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes) {
        int[][] distanceMatrix = EpreuveEnLigneStrategy._computeLevenshteinMatrix(epreuveBaliseCodes, allPunchedBaliseCodes);
        return EpreuveEnLigneStrategy._computeAlignment(epreuveBaliseCodes, allPunchedBaliseCodes, distanceMatrix);
    }

    private void _removeUnexpectedCodesFromPunchedCodes() {
        for (int i = this._allPunchedBaliseCodes.size() - 1; i >= 0; --i) {
            if (!this._isUnexpectedCodeValidated(this._allPunchedBaliseCodes.get(i))) continue;
            this._allPunchedBaliseCodes.remove(i);
            this._allBalisePunchTimesInMs.remove(i);
        }
    }

    private boolean _isUnexpectedCodeValidated(int punchedCode) {
        for (int codeToValidate : this._epreuveBaliseCodes) {
            if (punchedCode != codeToValidate) continue;
            return false;
        }
        return true;
    }

    private void _computeBalisePunchStatesAndPunchTimes() {
        this._punchState = new boolean[this._epreuveBaliseCodes.length];
        this._punchTimesInMs = new long[this._epreuveBaliseCodes.length];
        this._punchState = EpreuveEnLigneStrategy._computeBalisePunchStates(this._epreuveBaliseCodes, this._allPunchedBaliseCodes);
        for (int i = 0; i < this._punchState.length; ++i) {
            this._punchTimesInMs[i] = this._punchState[i] && i < this._allBalisePunchTimesInMs.size() ? this._allBalisePunchTimesInMs.get(i) : -1L;
        }
    }

    private static int[][] _computeLevenshteinMatrix(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes) {
        int[][] distanceMatrix = new int[epreuveBaliseCodes.length + 1][allPunchedBaliseCodes.size() + 1];
        for (int j = 0; j <= allPunchedBaliseCodes.size(); ++j) {
            distanceMatrix[0][j] = j;
        }
        for (int i = 1; i <= epreuveBaliseCodes.length; ++i) {
            distanceMatrix[i][0] = i;
            for (int j = 1; j <= allPunchedBaliseCodes.size(); ++j) {
                int substitutionCost = epreuveBaliseCodes[i - 1] == allPunchedBaliseCodes.get(j - 1) ? 0 : 1;
                distanceMatrix[i][j] = EpreuveEnLigneStrategy._min(distanceMatrix[i - 1][j] + 1, distanceMatrix[i][j - 1] + 1, distanceMatrix[i - 1][j - 1] + substitutionCost);
            }
        }
        return distanceMatrix;
    }

    private static boolean[] _computeAlignment(int[] epreuveBaliseCodes, List<Integer> allPunchedBaliseCodes, int[][] distanceMatrix) {
        boolean[] result = new boolean[epreuveBaliseCodes.length];
        int i = epreuveBaliseCodes.length;
        int j = allPunchedBaliseCodes.size();
        while (i != 0 && j != 0) {
            if (epreuveBaliseCodes[i - 1] == allPunchedBaliseCodes.get(j - 1)) {
                if (distanceMatrix[i][j] != distanceMatrix[i - 1][j - 1]) continue;
                result[i - 1] = true;
                --i;
                --j;
                continue;
            }
            if (distanceMatrix[i][j] == distanceMatrix[i - 1][j - 1] + 1) {
                --i;
                --j;
                continue;
            }
            if (distanceMatrix[i][j] == 1 + distanceMatrix[i - 1][j]) {
                --i;
                continue;
            }
            if (distanceMatrix[i][j] != 1 + distanceMatrix[i][j - 1]) continue;
            --j;
        }
        return result;
    }
}

