/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.balise.Balise;
import fr.geraidv3.model.balise.BaliseVector;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.GelEpreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.etape.EtapeEpreuveMap;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.data.BaliseResult;
import fr.geraidv3.result.data.IPunchValidatorStrategy;
import fr.geraidv3.result.data.PunchValidatorFactory;
import fr.geraidv3.result.puce.Puce;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

final class EpreuvePuceResult {
    private final Epreuve _epreuve;
    private final List<BaliseResult> _baliseResultVector;
    private final int[] _epreuveBaliseCodes;
    private final int _totalPoints;
    private final long _totalTimeInMs;
    private final long _durationInMs;
    private final long _totalTimeMultiplierInMs;
    private final long _gelDurationInMs;
    private final long[] _balisePunchTimesInMs;
    private final boolean[] _balisePunchStates;
    private final long _baliseBonusTimeInS;
    private final long _baliseMalusTimeInS;
    private final int _baliseBonusPoints;
    private final int _baliseMalusPoints;
    private long _timeOverrunInMs = 0L;
    private long _timeOverrunPenaltyTimeInS = 0L;
    private int _timeOverrunPenaltyPoints = 0;
    private boolean _usedInResult = true;

    @VisibleForTesting
    EpreuvePuceResult(Epreuve epreuve) {
        this._epreuve = epreuve;
        this._epreuveBaliseCodes = null;
        this._totalPoints = 0;
        this._totalTimeInMs = 0L;
        this._totalTimeMultiplierInMs = 0L;
        this._gelDurationInMs = 0L;
        this._durationInMs = 0L;
        this._baliseResultVector = new ArrayList<BaliseResult>();
        this._balisePunchTimesInMs = null;
        this._balisePunchStates = null;
        this._baliseBonusTimeInS = 0L;
        this._baliseMalusTimeInS = 0L;
        this._baliseBonusPoints = 0;
        this._baliseMalusPoints = 0;
    }

    EpreuvePuceResult(Epreuve epreuve, PuceResult puceResult) {
        long durationInMs;
        this._epreuve = epreuve;
        this._epreuveBaliseCodes = epreuve.getCodes();
        IPunchValidatorStrategy strategy = PunchValidatorFactory.createPunchValidator(epreuve, this._epreuveBaliseCodes, puceResult.getCodes(), puceResult.getTimeInMilliseconds());
        this._balisePunchStates = strategy.getBalisePunchStates();
        this._balisePunchTimesInMs = strategy.getBalisePunchTimesInMs();
        if (epreuve.isToBeDoneBeforeNextEpreuve()) {
            this._setPmToBalisesPunchedAfterStartOfNextEpreuve(epreuve, puceResult, this._balisePunchStates, this._epreuveBaliseCodes);
        }
        if (epreuve.isToBeDoneAfterPreviousEpreuve()) {
            this._setPmToBalisesPunchedBeforeFinishOfPreviousEpreuve(epreuve, puceResult, this._balisePunchStates, this._epreuveBaliseCodes);
        }
        this._baliseResultVector = this._buildEquipeBaliseResults(epreuve, this._balisePunchStates, this._balisePunchTimesInMs);
        Date startDate = this._calculateStartDate(epreuve, puceResult);
        Date finishDate = this._calculateFinishDate(epreuve, puceResult);
        if (finishDate.compareTo(DateTimeUtils.NO_TIME) != 0 && startDate.compareTo(DateTimeUtils.NO_TIME) != 0) {
            durationInMs = this._epreuve.computeDurationInMs(startDate, finishDate);
        } else {
            durationInMs = 0L;
            finishDate = null;
        }
        long[] bonusAndMalus = this._calculateBonusAndMalusFromBalises();
        this._baliseBonusPoints = (int)bonusAndMalus[0];
        this._baliseMalusPoints = (int)bonusAndMalus[1];
        this._baliseBonusTimeInS = bonusAndMalus[2];
        this._baliseMalusTimeInS = bonusAndMalus[3];
        if (epreuve instanceof GelEpreuve) {
            this._gelDurationInMs = this._calculateGelDurationAndOverrunPenalites();
        } else {
            if (!epreuve.isTimed()) {
                this._gelDurationInMs = epreuve.isToBeDoneAfterFinish() ? 0L : durationInMs;
                durationInMs = 0L;
                finishDate = null;
            } else {
                this._gelDurationInMs = 0L;
            }
            this._calculateTimeOverrunPenalites(durationInMs, finishDate);
        }
        this._durationInMs = durationInMs - this._gelDurationInMs;
        this._totalPoints = this._baliseBonusPoints + this._baliseMalusPoints - this._timeOverrunPenaltyPoints;
        this._totalTimeInMs = this._durationInMs * (long)this._epreuve.getTimeMultiplier() + this._baliseBonusTimeInS * 1000L + this._baliseMalusTimeInS * 1000L + this._timeOverrunPenaltyTimeInS * 1000L;
        this._totalTimeMultiplierInMs = this._durationInMs * (long)(this._epreuve.getTimeMultiplier() - 1);
    }

    int getTotalPoints() {
        return this._totalPoints;
    }

    long getTimeOverrunInMs() {
        return this._timeOverrunInMs;
    }

    long getTimeOverrunPenaltyTimeInS() {
        return this._timeOverrunPenaltyTimeInS;
    }

    int getBaliseBonusPoints() {
        return this._baliseBonusPoints;
    }

    int getBaliseMalusPoints() {
        return this._baliseMalusPoints;
    }

    int getTimeOverrunPenaltyPoints() {
        return this._timeOverrunPenaltyPoints;
    }

    long getTotalTimeInMs() {
        return this._totalTimeInMs;
    }

    long getDurationInMs() {
        return this._durationInMs;
    }

    long getGelDurationInMs() {
        return this._gelDurationInMs;
    }

    long getBaliseMalusTimeInS() {
        return this._baliseMalusTimeInS;
    }

    long getBaliseBonusTimeInS() {
        return this._baliseBonusTimeInS;
    }

    List<BaliseResult> getBaliseResultVector() {
        return this._baliseResultVector;
    }

    boolean isExcluded() {
        return !this._usedInResult;
    }

    void setExcluded() {
        this._usedInResult = false;
    }

    Epreuve getEpreuve() {
        return this._epreuve;
    }

    int[] getEpreuveBaliseCodes() {
        return this._epreuveBaliseCodes;
    }

    boolean[] getBalisePunchStates() {
        return this._balisePunchStates;
    }

    long[] getBalisePunchTimesInMs() {
        return this._balisePunchTimesInMs;
    }

    long getTotalTimeMultiplierInMs() {
        return this._totalTimeMultiplierInMs;
    }

    @VisibleForTesting
    void _calculateTimeOverrunPenalites(long actualTimeInMs, long timeLimitInMs) {
        this._timeOverrunInMs = actualTimeInMs - timeLimitInMs;
        if (this._timeOverrunInMs > 0L) {
            float timeOverrunInMn = (float)this._timeOverrunInMs / 60000.0f;
            int numberOfOverrunIntervals = (int)Math.ceil(timeOverrunInMn / (float)this._epreuve.getPenaltyIntervalInMn());
            this._timeOverrunPenaltyTimeInS = (long)(numberOfOverrunIntervals * this._epreuve.getPenaltyTimeInMn()) * 60L;
            this._timeOverrunPenaltyPoints = numberOfOverrunIntervals * this._epreuve.getPenaltyPoints();
        } else {
            this._timeOverrunInMs = 0L;
        }
    }

    @VisibleForTesting
    List<BaliseResult> _buildEquipeBaliseResults(Epreuve epreuve, boolean[] balisePunchStates, long[] balisePunchTimesInMs) {
        Vector<Balise> baliseVector = epreuve.getBaliseVector().getBaliseVector();
        ArrayList<BaliseResult> baliseResultVector = new ArrayList<BaliseResult>();
        for (int i = 0; i < baliseVector.size(); ++i) {
            Balise balise = baliseVector.get(i);
            BaliseResult baliseResult = new BaliseResult();
            baliseResult.setBaliseCode(balise.getNumber());
            if (balisePunchStates[i]) {
                baliseResult.setPenaltyPoints(balise.getPunchPointsBonus());
                baliseResult.setPenaltyTimeInS(balise.getPunchTimeBonusInS());
                baliseResult.setPunchTimeInMs(balisePunchTimesInMs[i]);
            } else {
                baliseResult.setPenaltyPoints(balise.getMispunchPointsPenalty());
                baliseResult.setPenaltyTimeInS(balise.getMispunchTimePenaltyInS());
            }
            baliseResultVector.add(baliseResult);
        }
        return baliseResultVector;
    }

    @VisibleForTesting
    static int _findFirstCodeWithTime(PuceResult puceResult, int[] epreuveBaliseCodes) {
        Puce puce = puceResult.getPuce();
        int marker = 0;
        int markerIndex = puce.getPartielIndex(epreuveBaliseCodes[0]);
        for (int i = 1; i < epreuveBaliseCodes.length; ++i) {
            int partielIndex = puce.getPartielIndex(epreuveBaliseCodes[i]);
            if (markerIndex >= 0 && (partielIndex < 0 || partielIndex >= markerIndex)) continue;
            marker = i;
            markerIndex = puce.getPartielIndex(epreuveBaliseCodes[marker]);
        }
        return marker;
    }

    @VisibleForTesting
    static int _findLastCodeWithTime(PuceResult puceResult, int[] epreuveBaliseCodes) {
        Puce puce = puceResult.getPuce();
        int marker = epreuveBaliseCodes.length - 1;
        int markerIndex = puce.getPartielIndex(epreuveBaliseCodes[marker]);
        for (int i = epreuveBaliseCodes.length - 2; i >= 0; --i) {
            int partielIndex = puce.getPartielIndex(epreuveBaliseCodes[i]);
            if (markerIndex != -1 && (partielIndex == -1 || partielIndex <= markerIndex)) continue;
            marker = i;
            markerIndex = puce.getPartielIndex(epreuveBaliseCodes[marker]);
        }
        return marker;
    }

    @VisibleForTesting
    long _calculateGelDurationAndOverrunPenalites() {
        long gelDurationInMs = 0L;
        boolean timed = true;
        long timeStopTimeInMs = 0L;
        Vector<Balise> baliseVector = this._epreuve.getBaliseVector().getBaliseVector();
        for (int i = 0; i < baliseVector.size(); ++i) {
            if (this._balisePunchStates[i] && timed) {
                timed = false;
                timeStopTimeInMs = this._balisePunchTimesInMs[i];
                continue;
            }
            if (this._balisePunchStates[i] && !timed) {
                timed = true;
                long durationInMs = Math.abs(this._balisePunchTimesInMs[i] - timeStopTimeInMs);
                if (this._epreuve.getLimitType() == LimitType.AVECLIMITETEMPS && durationInMs > this._epreuve.getDurationLimit().getTime()) {
                    this._calculateTimeOverrunPenalites(durationInMs, this._epreuve.getDurationLimit().getTime());
                }
                gelDurationInMs += durationInMs;
                continue;
            }
            if (timed) continue;
            timed = true;
        }
        return gelDurationInMs;
    }

    private void _setPmToBalisesPunchedAfterStartOfNextEpreuve(Epreuve epreuve, PuceResult puceResult, boolean[] balisePunchStates, int[] epreuveBaliseCodes) {
        ParcoursVariante variante = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        EtapeEpreuveMap etapeEpreuveMap = variante.getEtapeEpreuveMap();
        if (etapeEpreuveMap.isLastEpreuve(puceResult.getEtape(), epreuve)) {
            return;
        }
        BaliseVector nextEpreuveBalises = variante.getEtapeEpreuveMap().getBalisesOfNextEpreuve(puceResult.getEtape(), epreuve);
        if (nextEpreuveBalises == null) {
            return;
        }
        Vector<Balise> nextEpreuveBaliseVector = nextEpreuveBalises.getBaliseVector();
        block0: for (int i = 0; i < balisePunchStates.length; ++i) {
            if (!balisePunchStates[i]) continue;
            int baliseIndex = puceResult.getPuceIndex(epreuveBaliseCodes[i]);
            for (Balise nextEpreuveBalise : nextEpreuveBaliseVector) {
                int indexOfNextBalise = puceResult.getPuceIndex(nextEpreuveBalise.getNumber());
                if (indexOfNextBalise <= -1 || baliseIndex <= indexOfNextBalise) continue;
                balisePunchStates[i] = false;
                continue block0;
            }
        }
    }

    private void _setPmToBalisesPunchedBeforeFinishOfPreviousEpreuve(Epreuve epreuve, PuceResult puceResult, boolean[] balisePunchStates, int[] epreuveBaliseCodes) {
        ParcoursVariante variante = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        EtapeEpreuveMap etapeEpreuveMap = variante.getEtapeEpreuveMap();
        if (etapeEpreuveMap.isFirstEpreuveOfEtape(puceResult.getEtape(), epreuve)) {
            return;
        }
        BaliseVector previousEpreuveBalises = variante.getEtapeEpreuveMap().getBalisesOfPreviousEpreuve(puceResult.getEtape(), epreuve);
        if (previousEpreuveBalises == null) {
            return;
        }
        Vector<Balise> previousEpreuveBaliseVector = previousEpreuveBalises.getBaliseVector();
        block0: for (int i = 0; i < balisePunchStates.length; ++i) {
            if (!balisePunchStates[i]) continue;
            int baliseIndex = puceResult.getPuceIndex(epreuveBaliseCodes[i]);
            for (Balise previousEpreuveBalise : previousEpreuveBaliseVector) {
                int indexOfPreviousBalise = puceResult.getPuceIndex(previousEpreuveBalise.getNumber());
                if (indexOfPreviousBalise <= -1 || baliseIndex >= indexOfPreviousBalise) continue;
                balisePunchStates[i] = false;
                continue block0;
            }
        }
    }

    private Date _calculateStartDate(Epreuve epreuve, PuceResult puceResult) {
        ParcoursVariante variante = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        EtapeEpreuveMap etapeEpreuveMap = variante.getEtapeEpreuveMap();
        Etape etape = puceResult.getEtape();
        Puce puce = puceResult.getPuce();
        if (etapeEpreuveMap.isFirstEpreuveOfEtape(etape, epreuve)) {
            switch (etape.getStartType()) {
                case GROUPE: {
                    return etape.getStartHour();
                }
                case BOITIER: {
                    return puce.getStartTime();
                }
            }
        }
        if (epreuve.isStartTheLastBaliseOfPreviousEpreuve()) {
            return puce.getLastValidatedBaliseDateOfPreviousEpreuves(this._epreuveBaliseCodes);
        }
        Date startTime = DateTimeUtils.NO_TIME;
        if (this._epreuveBaliseCodes.length > 0) {
            if (epreuve.isAscenseur()) {
                boolean isDescendingOrder;
                int baliseIndex = EpreuvePuceResult._findFirstCodeWithTime(puceResult, this._epreuveBaliseCodes);
                boolean isAscendingOrder = baliseIndex == 0;
                boolean bl = isDescendingOrder = baliseIndex == this._epreuveBaliseCodes.length - 1;
                if (isAscendingOrder || isDescendingOrder) {
                    startTime = puce.getTimeOfCodeNaturalOrder(this._epreuveBaliseCodes[baliseIndex]);
                }
            } else {
                startTime = epreuve.isEnLigne() ? puce.getTimeOfCodeNaturalOrder(this._epreuveBaliseCodes[0]) : puce.getTimeFirstValidatedBalise(this._epreuveBaliseCodes);
            }
            if (startTime == DateTimeUtils.NO_TIME) {
                return puce.getLastValidatedBaliseDateOfPreviousEpreuves(this._epreuveBaliseCodes);
            }
        }
        return startTime;
    }

    private Date _calculateFinishDate(Epreuve epreuve, PuceResult puceResult) {
        ParcoursVariante varianteOfEpreuve = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        EtapeEpreuveMap etapeEpreuveMap = varianteOfEpreuve.getEtapeEpreuveMap();
        Puce puce = puceResult.getPuce();
        Etape etape = puceResult.getEtape();
        if (etapeEpreuveMap.isLastEpreuve(etape, epreuve)) {
            return puce.getFinishTime();
        }
        if (epreuve.isFinishTheFirstBaliseOfNextEpreuve()) {
            return puce.getFirstValidatedBaliseDateOfPreviousEpreuves(this._epreuveBaliseCodes);
        }
        Date finishTime = DateTimeUtils.NO_TIME;
        if (this._epreuveBaliseCodes.length > 0) {
            if (this._epreuve.isAscenseur()) {
                boolean isDescendingOrder;
                int baliseIndex = EpreuvePuceResult._findLastCodeWithTime(puceResult, this._epreuveBaliseCodes);
                boolean isAscendingOrder = baliseIndex == 0;
                boolean bl = isDescendingOrder = baliseIndex == this._epreuveBaliseCodes.length - 1;
                if (isAscendingOrder || isDescendingOrder) {
                    finishTime = puce.getTimeOfCodeReverseOrder(this._epreuveBaliseCodes[baliseIndex]);
                }
            } else {
                finishTime = epreuve.isEnLigne() ? puce.getTimeOfCodeReverseOrder(this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1]) : puce.getTimeLastValidatedBalise(this._epreuveBaliseCodes);
            }
            if (finishTime == DateTimeUtils.NO_TIME) {
                return puce.getFirstValidatedBaliseDateOfPreviousEpreuves(this._epreuveBaliseCodes);
            }
        }
        if (epreuve.isToBeDoneAfterFinish()) {
            finishTime = this._calculateOffTimedFinishTime(epreuve, puceResult, varianteOfEpreuve, finishTime);
        }
        return finishTime;
    }

    private long[] _calculateBonusAndMalusFromBalises() {
        long baliseBonusPoints = 0L;
        long baliseMalusPoints = 0L;
        long baliseBonusTimeInS = 0L;
        long baliseMalusTimeInS = 0L;
        for (BaliseResult baliseResult : this._baliseResultVector) {
            int points = baliseResult.getPenaltyPoints();
            if (points > 0) {
                baliseBonusPoints += (long)points;
            } else {
                baliseMalusPoints += (long)points;
            }
            long penaltyTimeInS = baliseResult.getPenaltyTimeInS();
            if (penaltyTimeInS <= 0L) {
                baliseBonusTimeInS += penaltyTimeInS;
                continue;
            }
            baliseMalusTimeInS += penaltyTimeInS;
        }
        return new long[]{baliseBonusPoints, baliseMalusPoints, baliseBonusTimeInS, baliseMalusTimeInS};
    }

    private void _calculateTimeOverrunPenalites(long totalDurationInMs, Date finishTime) {
        switch (this._epreuve.getLimitType()) {
            case AVECLIMITEHORAIRE: {
                boolean isTimed;
                boolean bl = isTimed = finishTime != null;
                if (!isTimed) break;
                this._calculateTimeOverrunPenalites(finishTime.getTime(), this._epreuve.getTimeLimit().getTime());
                break;
            }
            case AVECLIMITETEMPS: {
                this._calculateTimeOverrunPenalites(totalDurationInMs, this._epreuve.getDurationLimit().getTime());
                break;
            }
        }
    }

    private Date _calculateOffTimedFinishTime(Epreuve epreuve, PuceResult puceResult, ParcoursVariante variante, Date finishTime) {
        Date offTimedFinishTime = finishTime;
        if (epreuve.isFinishTheFirstBaliseOfNextEpreuve()) {
            int firstCode = variante.getEtapeEpreuveMap().getFirstCodeOfNextEpreuve(puceResult.getEtape(), epreuve);
            offTimedFinishTime = puceResult.getPuce().getTimeOfCodeNaturalOrder(firstCode);
        } else if (this._epreuveBaliseCodes.length > 0) {
            int marker;
            offTimedFinishTime = this._epreuve.isAscenseur() ? ((marker = EpreuvePuceResult._findLastCodeWithTime(puceResult, this._epreuveBaliseCodes)) == 0 || marker == this._epreuveBaliseCodes.length - 1 ? puceResult.getPuce().getTimeOfCodeReverseOrder(this._epreuveBaliseCodes[marker]) : DateTimeUtils.NO_TIME) : puceResult.getPuce().getTimeOfCodeReverseOrder(this._epreuveBaliseCodes[this._epreuveBaliseCodes.length - 1]);
            if (offTimedFinishTime.compareTo(DateTimeUtils.NO_TIME) == 0) {
                int firstCode = variante.getEtapeEpreuveMap().getFirstCodeOfNextEpreuve(puceResult.getEtape(), epreuve);
                offTimedFinishTime = puceResult.getPuce().getTimeOfCodeNaturalOrder(firstCode);
            }
        }
        return offTimedFinishTime;
    }
}

