/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.model.LimitType;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.epreuve.EpreuveVector;
import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.equipe.Equipier;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.ParcoursVariante;
import fr.geraidv3.result.EpreuveVisualizationLevel;
import fr.geraidv3.result.EtapeVisualizationLevel;
import fr.geraidv3.result.data.BaliseResult;
import fr.geraidv3.result.data.BaliseValidationState;
import fr.geraidv3.result.data.BaliseValidationStateVector;
import fr.geraidv3.result.data.EpreuvePuceResult;
import fr.geraidv3.result.data.EpreuvePuceResultVector;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public final class EtapePuceResult {
    public static final int FINISH_CODE = 15;
    public static final int START_CODE = 16;
    private final PuceResult _puceResult;
    private final EpreuvePuceResultVector _epreuvePuceResultVector;
    private final BaliseValidationStateVector _baliseValidationStateVector = new BaliseValidationStateVector();
    private final int _sanctionPoints;
    private final int _sanctionTimeInS;
    private Date _startDate = null;
    private Date _finishDate;
    private String _puce;
    private String _equipeBib;
    private String _equipeName;
    private String _equipeCategorie;
    private int _totalPoints = 0;
    private long _totalTimeInMs = 0L;
    private long _totalDurationInMs;
    private long _totalTimeMultiplierInMs = 0L;
    private long _gelDurationInMs = 0L;
    private int _baliseBonusPoints = 0;
    private int _baliseMalusPoints = 0;
    private long _baliseMalusTimeInS = 0L;
    private long _baliseBonusTimeInS = 0L;
    private int _timeOverrunPenaltyPoints = 0;
    private long _timeOverrunPenaltyTimeInS = 0L;
    private int _totalTimeOverrunPenaltyPoints = 0;
    private long _etapeTimeOverrunPenaltyTimeInMn = 0L;
    private int _etapeTimeOverrunPenaltyPoints = 0;
    private int _rank = 0;
    private long _timeOverrunInMs;

    public EtapePuceResult(PuceResult puceResult, int sanctionPoints, int sanctionTimeInS, boolean withTeammates) {
        this._puceResult = puceResult;
        this._sanctionPoints = sanctionPoints;
        this._sanctionTimeInS = sanctionTimeInS;
        this._markNotClassifiedResults(puceResult);
        this._setEquipeDataFromPuceResult(puceResult, withTeammates);
        this._calculateCourseDuration(puceResult);
        ParcoursVariante variante = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        if (variante == null) {
            this._epreuvePuceResultVector = new EpreuvePuceResultVector();
        } else {
            this._epreuvePuceResultVector = this._calculateResultForAllVarianteEpreuves(variante, puceResult);
            this._setFinishState();
            this._calculateOverrunPenalites(puceResult);
            this._calculateTotalResults();
            this._calculateExtraBalises(puceResult);
        }
        if (puceResult.getEquipe().isNotClassified()) {
            this._totalTimeInMs = 0L;
            this._totalPoints = 0;
            this._baliseBonusTimeInS = 0L;
            this._baliseBonusPoints = 0;
            this._baliseMalusPoints = 0;
            this._baliseMalusTimeInS = 0L;
            this._gelDurationInMs = 0L;
            this._totalDurationInMs = 0L;
        }
    }

    public String toHtml(Raid raid, boolean isReducedHtml) {
        return new HtmlHelper().generateHtml(raid, isReducedHtml);
    }

    public BaliseValidationStateVector getCodeValidationStateVector() {
        return this._baliseValidationStateVector;
    }

    public PuceResult getPuceResult() {
        return this._puceResult;
    }

    public int getTotalPoints() {
        return this._totalPoints;
    }

    public long getTotalTimeInMs() {
        return this._totalTimeInMs;
    }

    public int getRank() {
        return this._rank;
    }

    public void setRank(int value) {
        this._rank = value;
    }

    public String getEquipeBib() {
        return this._equipeBib;
    }

    public String getEquipeName() {
        return this._equipeName;
    }

    public String getEquipeCategorie() {
        return this._equipeCategorie;
    }

    public List<Object> getDataColumns(Epreuve epreuve, EpreuveVisualizationLevel visualizationType) {
        ArrayList<Object> result = new ArrayList<Object>();
        this._getEquipeSimpleDataColumns(result);
        for (int i = 0; i < this._epreuvePuceResultVector.getVector().size(); ++i) {
            EpreuvePuceResult epreuveResult = this._epreuvePuceResultVector.getVector().get(i);
            if (epreuveResult.isExcluded() || !epreuveResult.getEpreuve().getName().equals(epreuve.getName())) continue;
            EtapePuceResult._getEpreuveDataColumns(result, epreuveResult, this._puceResult.getEquipe().isNotClassified());
            if (visualizationType != EpreuveVisualizationLevel.AVEC_BALISES) continue;
            List<BaliseResult> baliseResultVector = epreuveResult.getBaliseResultVector();
            for (BaliseResult baliseResult : baliseResultVector) {
                EtapePuceResult._getEpreuveBaliseDataColumns(baliseResult, result, this._puceResult.getEquipe().isNotClassified());
            }
        }
        return result;
    }

    public List<Object> getDataColumns(EtapeVisualizationLevel level) {
        ArrayList<Object> result = new ArrayList<Object>();
        this._getEquipeGeneralDataColumns(result);
        if (level != EtapeVisualizationLevel.SIMPLE) {
            for (int i = 0; i < this._epreuvePuceResultVector.getVector().size(); ++i) {
                EpreuvePuceResult epreuveResult = this._epreuvePuceResultVector.getVector().get(i);
                if (epreuveResult.isExcluded()) continue;
                result.add(epreuveResult.getEpreuve().getName());
                EtapePuceResult._getEpreuveDataColumns(result, epreuveResult, this._puceResult.getEquipe().isNotClassified());
                if (level != EtapeVisualizationLevel.COMPLET) continue;
                List<BaliseResult> baliseResultVector = epreuveResult.getBaliseResultVector();
                for (BaliseResult baliseResult : baliseResultVector) {
                    EtapePuceResult._getEpreuveBaliseDataColumns(baliseResult, result, this._puceResult.getEquipe().isNotClassified());
                }
            }
        }
        return result;
    }

    public long getBaliseMalusTimeInS() {
        return this._baliseMalusTimeInS;
    }

    public int getBaliseMalusPoints() {
        return this._baliseMalusPoints;
    }

    public void recalculateTotalResults(long penalitesTimeInS, int penalitesPoints) {
        this._baliseMalusTimeInS = penalitesTimeInS;
        this._baliseMalusPoints = penalitesPoints;
        this._calculateTotalResults();
    }

    private void _calculateTotalResults() {
        this._totalPoints = this._baliseMalusPoints + this._baliseBonusPoints - this._timeOverrunPenaltyPoints + this._sanctionPoints - this._etapeTimeOverrunPenaltyPoints;
        this._totalTimeInMs = this._totalDurationInMs - this._gelDurationInMs + this._baliseMalusTimeInS * 1000L + this._baliseBonusTimeInS * 1000L + this._etapeTimeOverrunPenaltyTimeInMn * 60000L + this._timeOverrunPenaltyTimeInS + (long)this._sanctionTimeInS * 1000L + this._totalTimeMultiplierInMs;
        this._totalTimeOverrunPenaltyPoints = this._timeOverrunPenaltyPoints + this._etapeTimeOverrunPenaltyPoints;
    }

    private void _getEquipeSimpleDataColumns(List<Object> result) {
        if (this._rank < 0) {
            result.add("NC");
        } else {
            result.add(this._rank);
        }
        result.add(this._equipeBib);
        result.add(this._puce);
        result.add(this._equipeName);
        result.add(this._equipeCategorie);
    }

    private void _getEquipeGeneralDataColumns(List<Object> result) {
        if (this._rank < 0) {
            result.add("NC");
        } else {
            result.add(this._rank);
        }
        result.add(this._equipeBib);
        result.add(this._puce);
        result.add(this._equipeName);
        result.add(this._equipeCategorie);
        result.add(DateTimeUtils.millisecondsToString(this._totalTimeInMs));
        result.add("" + this._totalPoints);
        result.add(DateTimeUtils.dateToString(this._startDate));
        result.add(DateTimeUtils.dateToString(this._finishDate));
        result.add(DateTimeUtils.millisecondsToString(this._totalDurationInMs));
        result.add(DateTimeUtils.millisecondsToString(this._baliseBonusTimeInS * 1000L));
        result.add(DateTimeUtils.millisecondsToString(this._baliseMalusTimeInS * 1000L + this._timeOverrunPenaltyTimeInS));
        result.add(DateTimeUtils.millisecondsToString(this._etapeTimeOverrunPenaltyTimeInMn * 60000L));
        result.add(DateTimeUtils.millisecondsToString(this._gelDurationInMs));
        result.add(DateTimeUtils.millisecondsToString((long)this._sanctionTimeInS * 1000L));
        result.add("" + this._baliseBonusPoints);
        result.add("" + this._baliseMalusPoints);
        result.add("" + -this._totalTimeOverrunPenaltyPoints);
        result.add("" + this._sanctionPoints);
    }

    private static void _getEpreuveDataColumns(List<Object> result, EpreuvePuceResult epreuveResult, boolean isNotClassified) {
        if (isNotClassified) {
            result.add(DateTimeUtils.millisecondsToString(0L));
            result.add("");
            result.add("");
            result.add("");
            result.add("");
            result.add("");
            result.add("");
            result.add("");
            result.add("");
            result.add("");
        } else {
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getTotalTimeInMs()));
            result.add("" + epreuveResult.getTotalPoints());
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getDurationInMs()));
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getBaliseBonusTimeInS() * 1000L));
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getBaliseMalusTimeInS() * 1000L));
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getTimeOverrunPenaltyTimeInS() * 1000L));
            result.add(DateTimeUtils.millisecondsToString(epreuveResult.getGelDurationInMs()));
            result.add("" + epreuveResult.getBaliseBonusPoints());
            result.add("" + epreuveResult.getBaliseMalusPoints());
            result.add("" + -epreuveResult.getTimeOverrunPenaltyPoints());
        }
    }

    private static void _getEpreuveBaliseDataColumns(BaliseResult baliseResult, List<Object> result, boolean isNotClassified) {
        if (isNotClassified) {
            result.add("");
            result.add("");
            result.add("");
            result.add("");
        } else {
            result.add("" + baliseResult.getBaliseCode());
            if (baliseResult.isPunched()) {
                result.add(DateTimeUtils.millisecondsToString(baliseResult.getPunchTimeInMs()));
            } else {
                result.add("PM");
            }
            result.add("" + baliseResult.getPenaltyPoints());
            result.add(DateTimeUtils.millisecondsToString(baliseResult.getPenaltyTimeInS() * 1000L));
        }
    }

    private void _markNotClassifiedResults(PuceResult puceResult) {
        if (puceResult.getEquipe().isNotClassified()) {
            this._rank = -1;
        }
    }

    private void _setEquipeDataFromPuceResult(PuceResult puceResult, boolean withTeammates) {
        Equipe equipe = puceResult.getEquipe();
        this._equipeBib = equipe.getBib();
        this._puce = puceResult.getPuce().getId();
        this._equipeName = withTeammates ? equipe.getEquipierNames() : equipe.getName();
        this._equipeCategorie = equipe.getCategorie().getShortName();
    }

    private void _calculateCourseDuration(PuceResult puceResult) {
        switch (puceResult.getEtape().getStartType()) {
            case GROUPE: {
                this._startDate = puceResult.getEtape().getStartHour();
                this._baliseValidationStateVector.getStateVector().add(new BaliseValidationState(16, true));
                break;
            }
            case BOITIER: {
                this._startDate = puceResult.getPuce().getStartTime();
                this._baliseValidationStateVector.getStateVector().add(new BaliseValidationState(16, this._startDate.getTime() >= 0L));
                break;
            }
        }
        this._finishDate = puceResult.getPuce().getFinishTime();
        this._totalDurationInMs = this._finishDate.getTime() - this._startDate.getTime();
    }

    private void _calculateOverrunPenalites(PuceResult puceResult) {
        switch (puceResult.getEtape().getLimitType()) {
            case AVECLIMITEHORAIRE: {
                this._calculateTimeOverrunPenalites();
                break;
            }
            case AVECLIMITETEMPS: {
                this._calculateDurationOverrunPenalites();
                break;
            }
        }
    }

    private EpreuvePuceResultVector _calculateResultForAllVarianteEpreuves(ParcoursVariante variante, PuceResult puceResult) {
        EpreuvePuceResultVector epreuveResults = new EpreuvePuceResultVector();
        Vector<Epreuve> epreuves = variante.getEpreuvesOfEtape(puceResult.getEtape()).getEpreuveVector();
        int offset = 0;
        for (int i = 0; i < epreuves.size(); ++i) {
            Epreuve epreuve = (Epreuve)epreuves.get(i);
            epreuveResults.add(epreuve, puceResult);
            EpreuvePuceResult epreuveResult = epreuveResults.getVector().get(i + offset);
            if (epreuve.isBackAndForth()) {
                Epreuve epreuveBack = epreuve.getFactory().createBackEpreuve(epreuve);
                epreuveResults.add(epreuveBack, puceResult);
                EpreuvePuceResult epreuveBackResult = epreuveResults.getVector().get(i + ++offset);
                this._calculateEpreuveResult(epreuveBackResult);
            }
            if (epreuve.isExclusiveWithNextEpreuve() && i < epreuves.size() - 1) {
                Epreuve nextEpreuve = (Epreuve)epreuves.get(i + 1);
                epreuveResults.add(nextEpreuve, puceResult);
                EpreuvePuceResult nextEpreuveResult = epreuveResults.getVector().get(i + 1);
                ++i;
                if (epreuveResult.getTotalPoints() > nextEpreuveResult.getTotalPoints()) {
                    nextEpreuveResult.setExcluded();
                } else if (epreuveResult.getTotalPoints() < nextEpreuveResult.getTotalPoints()) {
                    epreuveResult.setExcluded();
                    epreuveResult = nextEpreuveResult;
                } else if (epreuveResult.getTotalTimeInMs() < nextEpreuveResult.getTotalTimeInMs()) {
                    nextEpreuveResult.setExcluded();
                } else {
                    epreuveResult.setExcluded();
                    epreuveResult = nextEpreuveResult;
                }
            }
            this._calculateEpreuveResult(epreuveResult);
        }
        return epreuveResults;
    }

    private void _setFinishState() {
        int twoDaysInMs = 172800000;
        boolean validated = this._finishDate.getTime() < 172800000L && this._finishDate.getTime() >= 0L;
        this._baliseValidationStateVector.getStateVector().add(new BaliseValidationState(15, validated));
    }

    private void _calculateExtraBalises(PuceResult puceResult) {
        ParcoursVariante variante = puceResult.getParcours().getVarianteFromEquipe(puceResult.getEquipe());
        EpreuveVector epreuvesOfEtape = variante.getEpreuvesOfEtape(puceResult.getEtape());
        this._baliseValidationStateVector.setExtraCodes(epreuvesOfEtape.getExtraCodes(puceResult));
    }

    private void _calculateEpreuveResult(EpreuvePuceResult epreuvePuceResult) {
        this._baliseValidationStateVector.add(epreuvePuceResult.getEpreuveBaliseCodes(), epreuvePuceResult.getBalisePunchStates(), epreuvePuceResult.getBalisePunchTimesInMs());
        this._baliseBonusPoints += epreuvePuceResult.getBaliseBonusPoints();
        this._baliseMalusPoints += epreuvePuceResult.getBaliseMalusPoints();
        this._baliseBonusTimeInS += epreuvePuceResult.getBaliseBonusTimeInS();
        this._baliseMalusTimeInS += epreuvePuceResult.getBaliseMalusTimeInS();
        this._timeOverrunPenaltyPoints += epreuvePuceResult.getTimeOverrunPenaltyPoints();
        this._timeOverrunPenaltyTimeInS += epreuvePuceResult.getTimeOverrunPenaltyTimeInS();
        this._gelDurationInMs += epreuvePuceResult.getGelDurationInMs();
        this._totalTimeMultiplierInMs += epreuvePuceResult.getTotalTimeMultiplierInMs();
    }

    private void _calculateTimeOverrunPenalites() {
        Etape etape = this._puceResult.getEtape();
        this._timeOverrunInMs = this._finishDate.getTime() - etape.getLimitHour().getTime();
        if (this._timeOverrunInMs > 0L) {
            float minutes = (float)this._timeOverrunInMs / 60000.0f / (float)etape.getPenaltyInterval();
            int startedMinutes = (int)Math.ceil(minutes);
            this._etapeTimeOverrunPenaltyPoints = startedMinutes * etape.getPenaltyPoints();
            this._etapeTimeOverrunPenaltyTimeInMn = (long)startedMinutes * (long)etape.getPenaltyTimeInMm();
        } else {
            this._timeOverrunInMs = 0L;
        }
    }

    private void _calculateDurationOverrunPenalites() {
        Etape etape = this._puceResult.getEtape();
        long differenceInMs = this._totalDurationInMs - etape.getDurationLimit().getTime();
        if (etape.isGelUsedInTimeLimit()) {
            differenceInMs -= this._gelDurationInMs;
        }
        if (differenceInMs > 0L) {
            float minutes = (float)differenceInMs / 60000.0f / (float)etape.getPenaltyInterval();
            int startedMinutes = (int)Math.ceil(minutes);
            this._etapeTimeOverrunPenaltyPoints = startedMinutes * etape.getPenaltyPoints();
            this._etapeTimeOverrunPenaltyTimeInMn = (long)startedMinutes * (long)etape.getPenaltyTimeInMm();
        }
    }

    final class HtmlHelper {
        HtmlHelper() {
        }

        String generateHtml(Raid raid, boolean isReducedResult) {
            StringBuilder html = new StringBuilder("<!DOCTYPE html><html lang='fr-FR'><head><meta charset='UTF-8'></head><body>");
            if (!raid.getPrintHeader().isEmpty()) {
                html.append("<font size=3>").append(raid.getPrintHeader()).append("</font><br><br>");
            }
            if (isReducedResult) {
                html.append(this._generateReducedHtml());
            } else {
                html.append(this._generateStandardHtml());
            }
            if (!raid.getPrintFooter().isEmpty()) {
                html.append("<br><font size=3>").append(raid.getPrintFooter()).append("</font>");
            }
            html.append("</body></html>");
            return html.toString();
        }

        String _generateReducedHtml() {
            StringBuilder result = new StringBuilder();
            result.append("<b>Dossard :</b> ").append(EtapePuceResult.this._puceResult.getEquipe().getBib()).append("<br>");
            result.append("<b>Puce :</b> ").append(EtapePuceResult.this._puceResult.getEquipe().getPuceIdsAsString()).append("<br>");
            result.append("<b>\u00c9quipe :</b> ").append(EtapePuceResult.this._puceResult.getEquipe().getName()).append("<br>");
            for (Equipier equipier : EtapePuceResult.this._puceResult.getEquipe().getEquipierVector().getEquipierVector()) {
                result.append("<span style='font-size:85%'>").append(equipier.toString()).append("</span><br>");
            }
            result.append("<b>Cat\u00e9gorie :</b> ").append(EtapePuceResult.this._puceResult.getEquipe().getCategorie().getLongName()).append("<br>");
            result.append("<br><b>Parcours :</b> ").append(EtapePuceResult.this._puceResult.getParcours().getName()).append("<br>");
            result.append("<b>\u00c9tape :</b> ").append(EtapePuceResult.this._puceResult.getEtape().getName()).append("<br>");
            result.append("<br>");
            result.append("<b>D\u00e9part :</b> ");
            result.append(DateTimeUtils.dateToString(EtapePuceResult.this._startDate)).append("<br>");
            result.append("<b>Arriv\u00e9e :</b> ");
            result.append(DateTimeUtils.dateToString(EtapePuceResult.this._finishDate)).append("<br>");
            result.append("<b>Temps de course :</b> ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._finishDate.getTime() - EtapePuceResult.this._startDate.getTime())).append("<br>");
            result.append("<b>Temps final :</b> ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._totalTimeInMs)).append("<br>");
            if (EtapePuceResult.this._baliseBonusPoints != 0) {
                result.append("<b>Points avant Bonif/Penal :</b> ");
                ParcoursVariante variante = EtapePuceResult.this._puceResult.getParcours().getVarianteFromEquipe(EtapePuceResult.this._puceResult.getEquipe());
                int totalPoints = variante.getEtapeEpreuveMap().getTotalPoints(EtapePuceResult.this._puceResult.getEtape());
                result.append(EtapePuceResult.this._baliseBonusPoints).append(" / ").append(totalPoints).append("<br>");
            }
            if (EtapePuceResult.this._baliseMalusPoints != 0) {
                result.append("<b>P\u00e9nalit\u00e9 de points :</b> ");
                result.append(EtapePuceResult.this._baliseMalusPoints).append("<br>");
            }
            if (EtapePuceResult.this._timeOverrunPenaltyPoints != 0) {
                result.append("<b>P\u00e9nalit\u00e9 en points pour d\u00e9passement :</b> ");
                result.append(-EtapePuceResult.this._timeOverrunPenaltyPoints).append("<br>");
            }
            if (EtapePuceResult.this._totalPoints != 0) {
                result.append("<b>Total des points :</b> ");
                result.append(EtapePuceResult.this._totalPoints).append("<br>");
            }
            if (EtapePuceResult.this._baliseBonusTimeInS != 0L) {
                result.append("<b>Bonification de temps :</b> ");
                result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._baliseBonusTimeInS * 1000L)).append("<br>");
            }
            if (EtapePuceResult.this._baliseMalusTimeInS + EtapePuceResult.this._timeOverrunPenaltyTimeInS != 0L) {
                result.append("<b>P\u00e9nalit\u00e9 de temps :</b> ");
                result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._baliseMalusTimeInS * 1000L + EtapePuceResult.this._timeOverrunPenaltyTimeInS)).append("<br>");
            }
            if (EtapePuceResult.this._gelDurationInMs != 0L) {
                result.append("<b>Gel du chronom\u00e8tre :</b>&nbsp;");
                result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._gelDurationInMs)).append("<br>");
            }
            if (EtapePuceResult.this._etapeTimeOverrunPenaltyTimeInMn != 0L) {
                result.append("<b>P\u00e9nalit\u00e9 en temps pour d\u00e9passement :</b> ");
                result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._etapeTimeOverrunPenaltyTimeInMn * 60000L)).append("<br>");
            }
            result.append("<br>");
            result.append(EtapePuceResult.this._puceResult.getCodesToHtml());
            result.append("<br>");
            int index = 0;
            List<EpreuvePuceResult> epreuveResults = EtapePuceResult.this._epreuvePuceResultVector.getVector();
            for (EpreuvePuceResult epreuveResult : epreuveResults) {
                if (epreuveResult.isExcluded()) continue;
                Epreuve epreuve = epreuveResult.getEpreuve();
                result.append("<br><b>\u00c9preuve</b> : ").append(epreuve.getName()).append("<br>");
                result.append("<font size=3>Dur\u00e9e de la section : ");
                if (epreuve.isTimed()) {
                    result.append(DateTimeUtils.millisecondsToString(Math.abs(epreuveResult.getDurationInMs()))).append("</font><br>");
                } else {
                    result.append("&#10060;").append("</font><br>");
                }
                result.append("<font size=3>Temps final : ");
                if (epreuve.isTimed()) {
                    result.append(DateTimeUtils.millisecondsToString(epreuveResult.getTotalTimeInMs())).append("</font><br>");
                } else {
                    result.append("&#10060;").append("</font><br>");
                }
                result.append("<table style='font-size:70%' cellpadding='5'>");
                result.append("<tr align=center style='font-weight:bold'><th>code</th><th>temps</th><th>code</th><th>temps</th><th>code</th><th>temps</th><th>code</th><th>temps</th></tr>");
                for (int j = 0; j < epreuveResult.getBaliseResultVector().size(); j += 4) {
                    List<BaliseValidationState> stateVector = EtapePuceResult.this._baliseValidationStateVector.getStateVector();
                    result.append("<tr align=center><td height=0><b>").append(stateVector.get(index + j + 1).getCode()).append("</b></td>");
                    result.append("<td height=0>").append(stateVector.get(index + j + 1).getPunchTimeAsString()).append("</td>");
                    if (j + 1 < epreuveResult.getBaliseResultVector().size()) {
                        result.append("<td height=0><b>").append(stateVector.get(index + j + 2).getCode()).append("</b></td>");
                        result.append("<td height=0>").append(stateVector.get(index + j + 2).getPunchTimeAsString()).append("</td>");
                    }
                    if (j + 2 < epreuveResult.getBaliseResultVector().size()) {
                        result.append("<td height=0><b>").append(stateVector.get(index + j + 3).getCode()).append("</b></td>");
                        result.append("<td height=0>").append(stateVector.get(index + j + 3).getPunchTimeAsString()).append("</td>");
                    }
                    if (j + 3 < epreuveResult.getBaliseResultVector().size()) {
                        result.append("<td height=0><b>").append(stateVector.get(index + j + 4).getCode()).append("</b></td>");
                        result.append("<td height=0>").append(stateVector.get(index + j + 4).getPunchTimeAsString()).append("</td>");
                    }
                    result.append("</tr>");
                }
                index += epreuveResult.getBaliseResultVector().size();
                result.append("</table>");
            }
            return result.toString();
        }

        String _generateStandardHtml() {
            StringBuilder result = new StringBuilder();
            result.append("<table><tr>");
            result.append("<td valign='top'><table cellpadding='8'>");
            result.append("<tr><td>Parcours : ").append(EtapePuceResult.this._puceResult.getParcours().getName()).append("</td></tr>");
            result.append("<tr><td>\u00c9tape : ").append(EtapePuceResult.this._puceResult.getEtape().getName()).append("</td></tr>");
            result.append("</table>");
            result.append("<td><table cellpadding='8'>");
            result.append("<tr><td>Dossard : ").append(EtapePuceResult.this._puceResult.getEquipe().getBib()).append("</td></tr>");
            result.append("<tr><td>\u00c9quipe : ").append(EtapePuceResult.this._puceResult.getEquipe().getName()).append("</td></tr>");
            for (Equipier equipier : EtapePuceResult.this._puceResult.getEquipe().getEquipierVector().getEquipierVector()) {
                result.append("<tr><td><span style='font-size:85%'>").append(equipier.toString()).append("</span><br></td></tr>");
            }
            result.append("</table></td>");
            result.append("</tr></table>");
            result.append("<b>R\u00e9sultats de l'\u00e9tape</b><br>");
            result.append("Temps final : ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._totalTimeInMs)).append("<br>");
            result.append("Total des points : ");
            result.append(EtapePuceResult.this._totalPoints).append("<br><br>");
            result.append("<b>D\u00e9tails de l'\u00e9tape</b><br><table style='font-size:80%' cellpadding='5'>");
            result.append("<tr><td>Heure de d\u00e9part : ").append(DateTimeUtils.dateToString(EtapePuceResult.this._startDate)).append("</td>");
            result.append("<td>Bonification de temps : ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._baliseBonusTimeInS * 1000L)).append("</td>");
            result.append("<td>Bonification de points : ");
            result.append(EtapePuceResult.this._baliseBonusPoints).append("</td></tr>");
            result.append("<tr><td>Heure d'arriv\u00e9e : ").append(DateTimeUtils.dateToString(EtapePuceResult.this._finishDate)).append("</td>");
            result.append("<td>P\u00e9nalit\u00e9 de temps : ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._baliseMalusTimeInS * 1000L + EtapePuceResult.this._timeOverrunPenaltyTimeInS)).append("</td>");
            result.append("<td>P\u00e9nalit\u00e9 de points : ");
            result.append(EtapePuceResult.this._baliseMalusPoints).append("</td></tr>");
            result.append("<tr><td>Temps de course : ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._totalDurationInMs)).append("</td>");
            result.append("<td>Gel du chronom\u00e8tre : ");
            result.append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._gelDurationInMs)).append("</td></tr>");
            result.append("<tr>");
            result.append("<td>Temps de d\u00e9passement : ").append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._timeOverrunInMs)).append("</td>");
            result.append("<td>P\u00e9nalit\u00e9 de d\u00e9passement (pts) : ").append(-EtapePuceResult.this._timeOverrunPenaltyPoints).append("</td>");
            result.append("<td>P\u00e9nalit\u00e9 de d\u00e9passement (tps) : ").append(DateTimeUtils.millisecondsToString(EtapePuceResult.this._etapeTimeOverrunPenaltyTimeInMn * 60000L)).append("</td></tr>");
            result.append("</table>");
            result.append("<br>").append(EtapePuceResult.this._puceResult.getCodesToHtml()).append("<br>");
            for (int i = 0; i < EtapePuceResult.this._epreuvePuceResultVector.getVector().size(); ++i) {
                EpreuvePuceResult epreuveResult = EtapePuceResult.this._epreuvePuceResultVector.getVector().get(i);
                if (epreuveResult.isExcluded()) continue;
                Epreuve epreuve = epreuveResult.getEpreuve();
                result.append("<br><b>").append(epreuve.getType().toCapitalizeString()).append(" : ").append(epreuve.getName()).append("</b></br>");
                result.append("<span style='font-size:80%';>");
                if (epreuve.getTimeMultiplier() > 1) {
                    result.append(" (Multiplicateur de temps : ").append(epreuve.getTimeMultiplier()).append(" )<br>");
                }
                if (epreuve.getLimitType() != LimitType.SANSLIMITE) {
                    result.append(" P\u00e9nalit\u00e9 de d\u00e9passement : ").append(epreuve.getPenaltyPoints()).append(" pts");
                    result.append(" et ").append(epreuve.getPenaltyTimeInMn()).append(" min pour chaque ").append(epreuve.getPenaltyIntervalInMn()).append(" min<br>");
                }
                result.append("</span>");
                result.append("<table style='font-size:80%' cellpadding='5'>");
                result.append("<tr><td>Dur\u00e9e de la section : ");
                if (epreuve.isTimed()) {
                    result.append(DateTimeUtils.millisecondsToString(Math.abs(epreuveResult.getDurationInMs()))).append("</td>");
                } else {
                    result.append("&#10060;").append("</font><br>");
                }
                result.append("<td>Bonification de temps : ");
                result.append(DateTimeUtils.millisecondsToString(epreuveResult.getBaliseBonusTimeInS() * 1000L)).append("</td>");
                result.append("<td>Bonification de points : ");
                result.append(epreuveResult.getBaliseBonusPoints()).append("</td></tr>");
                result.append("<tr><td>Total des points : ");
                result.append(epreuveResult.getTotalPoints()).append("</td>");
                result.append("<td>P\u00e9nalit\u00e9 de temps : ");
                result.append(DateTimeUtils.millisecondsToString(epreuveResult.getBaliseMalusTimeInS() * 1000L)).append("</td>");
                result.append("<td>P\u00e9nalit\u00e9 de points : ");
                result.append(epreuveResult.getBaliseMalusPoints()).append("</td></tr>");
                result.append("<tr><td>Temps final : ");
                if (epreuve.isTimed()) {
                    result.append(DateTimeUtils.millisecondsToString(epreuveResult.getTotalTimeInMs())).append("</td>");
                } else {
                    result.append("&#10060;").append("</font><br>");
                }
                result.append("</td></tr>");
                result.append("<tr>");
                result.append("<td>Temps de d\u00e9passement : ").append(DateTimeUtils.millisecondsToString(epreuveResult.getTimeOverrunInMs()));
                result.append("<td>P\u00e9nalit\u00e9 de d\u00e9passement (pts) : ");
                result.append(-epreuveResult.getTimeOverrunPenaltyPoints()).append("</td>");
                result.append("<td>P\u00e9nalit\u00e9 de d\u00e9passement (tps) : ");
                result.append(DateTimeUtils.millisecondsToString(epreuveResult.getTimeOverrunPenaltyTimeInS() * 1000L)).append("</td></tr></table>");
                result.append("<table style='font-size:70%;' cellpadding='5'>");
                result.append("<tr align=center style='font-weight:bold'><th>Code</th><th>Validation</th><th>Points</th><th>Temps<br>penal</th><th>Code</th><th>Validation</th><th>Points</th><th>Temps<br>penal</th><th>Code</th><th>Validation</th><th>Points</th><th>Temps<br>penal</th></tr>");
                for (int j = 0; j < EtapePuceResult.this._epreuvePuceResultVector.getVector().get(i).getBaliseResultVector().size(); j += 3) {
                    result.append("<tr>");
                    for (int k = 0; k < 3; ++k) {
                        if (EtapePuceResult.this._epreuvePuceResultVector.getVector().get(i).getBaliseResultVector().size() <= j + k) continue;
                        BaliseResult baliseResult = EtapePuceResult.this._epreuvePuceResultVector.getVector().get(i).getBaliseResultVector().get(j + k);
                        result.append("<td><b>").append(baliseResult.getBaliseCode()).append("</b></td>");
                        result.append("<td>");
                        if (baliseResult.isPunched()) {
                            result.append(DateTimeUtils.millisecondsToString(baliseResult.getPunchTimeInMs()));
                        } else {
                            result.append("PM</td>");
                        }
                        result.append("<td>").append(this._sign(baliseResult.getPenaltyPoints())).append(baliseResult.getPenaltyPoints()).append("</td><td>").append(this._sign(baliseResult.getPenaltyTimeInS())).append(DateTimeUtils.millisecondsToString(baliseResult.getPenaltyTimeInS() * 1000L)).append("</td>");
                    }
                    result.append("</tr>");
                }
                result.append("</table>");
            }
            return result.toString();
        }

        private String _sign(long time) {
            return time > 0L ? "+" : "";
        }
    }
}

