/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.data;

import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.result.data.EpreuveAuScoreStrategy;
import fr.geraidv3.result.data.EpreuveEnAscenseurStrategy;
import fr.geraidv3.result.data.EpreuveEnLigneStrategy;
import fr.geraidv3.result.data.IPunchValidatorStrategy;
import java.util.List;

class PunchValidatorFactory {
    PunchValidatorFactory() {
    }

    static IPunchValidatorStrategy createPunchValidator(Epreuve epreuve, int[] epreuveBaliseCodes, List<Integer> punchedBaliseCodes, List<Long> balisePunchTimesInMs) {
        if (epreuve.isAscenseur()) {
            return new EpreuveEnAscenseurStrategy(epreuveBaliseCodes, punchedBaliseCodes, balisePunchTimesInMs, epreuve.isBackAndForth());
        }
        if (epreuve.isEnLigne()) {
            return new EpreuveEnLigneStrategy(epreuveBaliseCodes, punchedBaliseCodes, balisePunchTimesInMs);
        }
        return new EpreuveAuScoreStrategy(epreuveBaliseCodes, punchedBaliseCodes, balisePunchTimesInMs);
    }
}

