/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.parcours;

import fr.geraidv3.L10n;
import fr.geraidv3.model.Raid;
import fr.geraidv3.model.categorie.Categorie;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.ParcoursVisualizationLevel;
import fr.geraidv3.result.data.EquipeHelper;
import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.parcours.ParcoursHtmlHelper;
import fr.geraidv3.result.parcours.PuceParcoursResult;
import fr.geraidv3.result.parcours.PuceParcoursResultVector;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public final class ParcoursResult {
    private static final int ETAPE_COLUMN_COUNT = 3;
    private final Raid _raid;
    private final Parcours _parcours;
    private final Categorie _categorie;
    private final PuceParcoursResultVector _tableRowData;
    private final String[] _tableColumnsHeaders;
    private final String[] _columnTooltips;
    private final List<EtapePuceResult> _etapePuceResults = new ArrayList<EtapePuceResult>();

    public ParcoursResult(Raid raid, Parcours parcours, Categorie categorie, ParcoursVisualizationLevel visualizationType, boolean useWorstEquipePuce, boolean useCumulativePenalites) {
        this._raid = raid;
        this._categorie = categorie;
        this._parcours = parcours;
        String[][] columnHeaders = this._createTableColumnHeaders(visualizationType);
        this._tableColumnsHeaders = columnHeaders[0];
        this._columnTooltips = columnHeaders[1];
        this._tableRowData = this._createTableRowData(useWorstEquipePuce, useCumulativePenalites);
    }

    public Raid getRaid() {
        return this._raid;
    }

    public Parcours getParcours() {
        return this._parcours;
    }

    public Categorie getCategorie() {
        return this._categorie;
    }

    public String[] getTableColumnHeaders() {
        return this._tableColumnsHeaders;
    }

    public String[] getTableColumnTooltips() {
        return this._columnTooltips;
    }

    public Object[][] getTableRowData() {
        List<PuceParcoursResult> equipeResults = this._tableRowData.getPuceParcoursResults();
        Object[][] data = new Object[equipeResults.size()][this._tableColumnsHeaders.length];
        for (int i = 0; i < equipeResults.size(); ++i) {
            PuceParcoursResult equipeResult = equipeResults.get(i);
            data[i][0] = equipeResult.getRank() == -1 ? "NC" : Integer.valueOf(equipeResult.getRank());
            data[i][1] = equipeResult.getEquipe().getBib();
            data[i][2] = equipeResult.getPuceId();
            data[i][3] = this._raid.withTeammates() ? equipeResult.getEquipe().getEquipierNames() : equipeResult.getEquipe().getName();
            data[i][4] = equipeResult.getEquipe().getCategorie().getShortName();
            data[i][5] = equipeResult.getTotalPoints();
            data[i][6] = DateTimeUtils.millisecondsToString(equipeResult.getTotalTime());
            for (int j = 7; j < this._tableColumnsHeaders.length; j += 3) {
                int etapeIndex = (j - 7) / 3;
                data[i][j] = equipeResult.getEtapeName(etapeIndex);
                data[i][j + 1] = equipeResult.getEtapePoints(etapeIndex);
                data[i][j + 2] = equipeResult.getEtapeTemps(etapeIndex);
            }
        }
        return data;
    }

    public String getTableColumnHeadersAsHtml() {
        return ParcoursHtmlHelper.getTableColumnHeaders(this._parcours);
    }

    public String getDataAsHtml() {
        return ParcoursHtmlHelper.getTableRowData(this._parcours, this._tableRowData, this._raid.withTeammates());
    }

    @VisibleForTesting
    static void _moveNonClassifiedEquipesAtTheEnd(PuceParcoursResultVector equipeResultsVector) {
        List<PuceParcoursResult> equipeResults = equipeResultsVector.getPuceParcoursResults();
        int index = 0;
        for (int i = 0; i < equipeResults.size(); ++i) {
            if (equipeResults.get(index).getRank() < 0) {
                PuceParcoursResult remove = equipeResults.remove(index);
                equipeResults.add(remove);
                continue;
            }
            ++index;
        }
    }

    @VisibleForTesting
    static void _rankClassifiedEquipes(PuceParcoursResultVector equipeResultsVector) {
        List<PuceParcoursResult> equipeResult = equipeResultsVector.getPuceParcoursResults();
        for (int i = 0; i < equipeResult.size(); ++i) {
            if (equipeResult.get(i).getRank() <= -1) continue;
            equipeResult.get(i).setRank(i + 1);
        }
    }

    private String[][] _createTableColumnHeaders(ParcoursVisualizationLevel visualizationType) {
        ArrayList<String> columnHeaders = new ArrayList<String>();
        ArrayList<String> columnTooltips = new ArrayList<String>();
        columnHeaders.add(L10n.getString("table_header.column.rank.title"));
        columnTooltips.add(L10n.getString("table_header.column.rank.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.dossard.title"));
        columnTooltips.add(L10n.getString("table_header.column.dossard.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.puce.title"));
        columnTooltips.add(L10n.getString("table_header.column.puce.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.equipe.title"));
        columnTooltips.add(L10n.getString("table_header.column.equipe.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.categorie.title"));
        columnTooltips.add(L10n.getString("table_header.column.categorie.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.points.title"));
        columnTooltips.add(L10n.getString("table_header.column.points.tooltip"));
        columnHeaders.add(L10n.getString("table_header.column.temps.title"));
        columnTooltips.add(L10n.getString("table_header.column.temps.tooltip"));
        if (visualizationType == ParcoursVisualizationLevel.AVEC_ETAPE && this._parcours != null) {
            for (int i = 0; i < 3 * this._parcours.getEtapeVector().size(); i += 3) {
                columnHeaders.add(L10n.getString("table_header.column.etape.title"));
                columnTooltips.add(L10n.getString("table_header.column.etape.tooltip"));
                columnHeaders.add(L10n.getString("table_header.column.points.title"));
                columnTooltips.add(L10n.getString("table_header.column.points.tooltip"));
                columnHeaders.add(L10n.getString("table_header.column.temps.title"));
                columnTooltips.add(L10n.getString("table_header.column.temps.tooltip"));
            }
        }
        return new String[][]{columnHeaders.toArray(new String[0]), columnTooltips.toArray(new String[0])};
    }

    private PuceParcoursResultVector _createTableRowData(boolean useWorstEquipePuce, boolean useCumulativePenalites) {
        PuceParcoursResultVector equipeResults = this._createEquipeResultsFromPuceResults(useCumulativePenalites);
        ParcoursResult._sortEquipesFromPointsThenTime(equipeResults);
        ParcoursResult._moveNonClassifiedEquipesAtTheEnd(equipeResults);
        if (useWorstEquipePuce) {
            ParcoursResult._keepOnlyWorstResultForEquipe(equipeResults);
        }
        ParcoursResult._rankClassifiedEquipes(equipeResults);
        return equipeResults;
    }

    private PuceParcoursResultVector _createEquipeResultsFromPuceResults(boolean useCumulativePenalites) {
        PuceParcoursResultVector equipeResults = new PuceParcoursResultVector();
        boolean isAllCategories = !this._raid.getCategorieVector().getCategorieVector().contains(this._categorie);
        List<PuceResult> puceResults = this._raid.getPuceResultVector().getPuceResultVector();
        boolean withTeammates = this._raid.withTeammates();
        for (PuceResult puceResult : puceResults) {
            Parcours parcours;
            if (puceResult.getEquipe().isAbsent() || !this._parcours.hasSameNameAs(parcours = puceResult.getParcours())) continue;
            Etape etape = puceResult.getEtape();
            String equipePuceId = puceResult.getPuce().getId();
            int sanctionPoints = this._raid.getPenaliteVector().getSanctionPoints(parcours, etape, equipePuceId);
            int sanctionTimeInS = this._raid.getPenaliteVector().getSanctionTimeInS(parcours, etape, equipePuceId);
            if (!isAllCategories && puceResult.getEquipe().getCategorie() != this._categorie) continue;
            EtapePuceResult etapeResult = new EtapePuceResult(puceResult, sanctionPoints, sanctionTimeInS, withTeammates);
            this._etapePuceResults.add(etapeResult);
        }
        if (useCumulativePenalites) {
            Map<String, List<EtapePuceResult>> equipes = EquipeHelper.groupByEquipes(this._etapePuceResults);
            for (Map.Entry<String, List<EtapePuceResult>> entry : equipes.entrySet()) {
                List<EtapePuceResult> results = entry.getValue();
                long penalitesTimeInS = 0L;
                int penalitesPoints = 0;
                for (EtapePuceResult result : results) {
                    penalitesTimeInS += result.getBaliseMalusTimeInS();
                    penalitesPoints += result.getBaliseMalusPoints();
                }
                for (EtapePuceResult result : results) {
                    result.recalculateTotalResults(penalitesTimeInS, penalitesPoints);
                }
            }
        }
        for (EtapePuceResult etapePuceResult : this._etapePuceResults) {
            equipeResults.addResult(etapePuceResult, etapePuceResult.getPuceResult());
        }
        return equipeResults;
    }

    private static void _sortEquipesFromPointsThenTime(PuceParcoursResultVector equipeResults) {
        equipeResults.sort();
    }

    private static void _keepOnlyWorstResultForEquipe(PuceParcoursResultVector equipeResults) {
        equipeResults.keepOnlyWorstResultForEquipe();
    }
}

