/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.parcours;

import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.puce.PuceResult;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.Arrays;
import org.jetbrains.annotations.VisibleForTesting;

final class PuceParcoursResult
implements Comparable<PuceParcoursResult> {
    private final Parcours _parcours;
    private final Equipe _equipe;
    private final String _puceId;
    private final String[] _etapes;
    private final String[] _points;
    private final String[] _temps;
    private int _rank;
    private int _totalPoints = 0;
    private long _totalTime = 0L;
    private int _numberOfEtapes = 0;

    PuceParcoursResult(Parcours parcours, Equipe equipe, String puceId) {
        this._parcours = parcours;
        this._equipe = equipe;
        this._puceId = puceId;
        this._rank = equipe.isNotClassified() ? -1 : 0;
        int numberOfEtape = parcours.getEtapeVector().size();
        this._etapes = new String[numberOfEtape];
        Arrays.fill(this._etapes, "");
        this._points = new String[numberOfEtape];
        Arrays.fill(this._points, "");
        this._temps = new String[numberOfEtape];
        Arrays.fill(this._temps, "");
    }

    @Override
    public int compareTo(PuceParcoursResult result) {
        return PuceParcoursResult._compareTo(this._totalPoints, result._totalPoints, this._numberOfEtapes, result._numberOfEtapes, this._totalTime, result._totalTime);
    }

    Equipe getEquipe() {
        return this._equipe;
    }

    int getRank() {
        return this._rank;
    }

    void setRank(int value) {
        this._rank = value;
    }

    String getEtapeName(int index) {
        return this._etapes[index];
    }

    String getEtapePoints(int index) {
        return this._points[index];
    }

    String getEtapeTemps(int index) {
        return this._temps[index];
    }

    int getTotalPoints() {
        return this._totalPoints;
    }

    long getTotalTime() {
        return this._totalTime;
    }

    String getPuceId() {
        return this._puceId;
    }

    void calculateResultData(EtapePuceResult result, PuceResult puceResult) {
        this._totalPoints += result.getTotalPoints();
        this._totalTime += result.getTotalTimeInMs();
        Etape etape = puceResult.getEtape();
        int index = this._parcours.getIndexOfEtape(etape);
        this._etapes[index] = etape.getName();
        this._points[index] = "" + result.getTotalPoints();
        this._temps[index] = DateTimeUtils.millisecondsToString(result.getTotalTimeInMs());
        this._numberOfEtapes = this._setNumberOfEtapes();
    }

    @VisibleForTesting
    static int _compareTo(int totalPoints1, int totalPoints2, int numberOfEtapes1, int numberOfEtapes2, long compensatedTime1, long compensatedTime2) {
        if (totalPoints1 > totalPoints2) {
            return -1;
        }
        if (totalPoints1 < totalPoints2) {
            return 1;
        }
        if (numberOfEtapes1 > numberOfEtapes2) {
            return -1;
        }
        if (numberOfEtapes1 < numberOfEtapes2) {
            return 1;
        }
        return Long.compare(compensatedTime1, compensatedTime2);
    }

    private int _setNumberOfEtapes() {
        int numberOfEtapes = 0;
        for (String temp : this._temps) {
            if (temp.isEmpty()) continue;
            ++numberOfEtapes;
        }
        return numberOfEtapes;
    }
}

