/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.parcours;

import fr.geraidv3.result.data.EtapePuceResult;
import fr.geraidv3.result.parcours.PuceParcoursResult;
import fr.geraidv3.result.puce.PuceResult;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

final class PuceParcoursResultVector {
    private final List<PuceParcoursResult> _puceParcoursResults;

    PuceParcoursResultVector() {
        this._puceParcoursResults = new ArrayList<PuceParcoursResult>();
    }

    @VisibleForTesting
    PuceParcoursResultVector(List<PuceParcoursResult> vector) {
        this._puceParcoursResults = vector;
    }

    List<PuceParcoursResult> getPuceParcoursResults() {
        return this._puceParcoursResults;
    }

    void addResult(EtapePuceResult etapeResult, PuceResult puceResult) {
        PuceParcoursResult parcoursResult = this._getOrAddPuceParcoursResult(puceResult);
        parcoursResult.calculateResultData(etapeResult, puceResult);
    }

    @VisibleForTesting
    PuceParcoursResult _getOrAddPuceParcoursResult(PuceResult puceResult) {
        for (PuceParcoursResult puceParcoursResult : this._puceParcoursResults) {
            if (!puceParcoursResult.getPuceId().equals(puceResult.getPuce().getId())) continue;
            return puceParcoursResult;
        }
        PuceParcoursResult puceParcoursResult = new PuceParcoursResult(puceResult.getParcours(), puceResult.getEquipe(), puceResult.getPuce().getId());
        this._puceParcoursResults.add(puceParcoursResult);
        return puceParcoursResult;
    }

    void sort() {
        this._puceParcoursResults.sort(null);
    }

    void keepOnlyWorstResultForEquipe() {
        PuceParcoursResultVector._keepOnlyWorstResultForEquipe(this._puceParcoursResults);
    }

    @VisibleForTesting
    static void _keepOnlyWorstResultForEquipe(List<PuceParcoursResult> puceParcoursResults) {
        for (int i = 0; i < puceParcoursResults.size(); ++i) {
            String bib = puceParcoursResults.get(i).getEquipe().getBib();
            if (bib.isEmpty() || !PuceParcoursResultVector._existsBib(puceParcoursResults, i + 1, bib)) continue;
            puceParcoursResults.remove(i);
            --i;
        }
    }

    private static boolean _existsBib(List<PuceParcoursResult> equipeResults, int index, String bib) {
        for (int i = index; i < equipeResults.size(); ++i) {
            if (!equipeResults.get(i).getEquipe().getBib().equals(bib)) continue;
            return true;
        }
        return false;
    }
}

