/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.penalite;

import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public final class Penalite {
    private final List<PenaliteIndividuelle> _penaliteIndividuelleVector = new ArrayList<PenaliteIndividuelle>();
    private Parcours _parcours = null;
    private Etape _etape = null;
    private String _name = "Nom de la p\u00e9nalit\u00e9";

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Parcours getParcours() {
        return this._parcours;
    }

    public void setParcours(Parcours parcours) {
        this._parcours = parcours;
    }

    public Etape getEtape() {
        return this._etape;
    }

    public void setEtape(Etape etape) {
        this._etape = etape;
    }

    public List<PenaliteIndividuelle> getPenaliteIndividuelleVector() {
        return this._penaliteIndividuelleVector;
    }

    public void addPenaliteIndividuelle(PenaliteIndividuelle penalite) {
        if (!penalite.getPuceIds().isEmpty()) {
            this._deletePenalitePuce(penalite.getPuceIds());
            this._penaliteIndividuelleVector.add(penalite);
        }
    }

    @VisibleForTesting
    void _deletePenalitePuce(String puceIds) {
        for (int i = 0; i < this._penaliteIndividuelleVector.size(); ++i) {
            if (!this._penaliteIndividuelleVector.get(i).getPuceIds().equals(puceIds)) continue;
            this._penaliteIndividuelleVector.remove(i);
            return;
        }
    }

    public boolean hasPuce(String puceIds) {
        for (PenaliteIndividuelle penaliteIndividuelle : this._penaliteIndividuelleVector) {
            if (!penaliteIndividuelle.getPuceIds().equals(puceIds)) continue;
            return true;
        }
        return false;
    }

    public int getPoints(String puceIds) {
        for (PenaliteIndividuelle penaliteIndividuelle : this._penaliteIndividuelleVector) {
            if (!penaliteIndividuelle.getPuceIds().equals(puceIds)) continue;
            return penaliteIndividuelle.getPoints();
        }
        return 0;
    }

    public int getTempsInS(String puceIds) {
        for (PenaliteIndividuelle penaliteIndividuelle : this._penaliteIndividuelleVector) {
            if (!penaliteIndividuelle.getPuceIds().equals(puceIds)) continue;
            return penaliteIndividuelle.getTimeInS();
        }
        return 0;
    }

    public PenaliteIndividuelle getPenaliteIndividuelle(String puceIds) {
        for (PenaliteIndividuelle penaliteIndividuelle : this._penaliteIndividuelleVector) {
            if (!puceIds.equals(penaliteIndividuelle.getPuceIds())) continue;
            return penaliteIndividuelle;
        }
        return null;
    }
}

