/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.penalite;

import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.penalite.Penalite;
import fr.geraidv3.result.penalite.PenaliteIndividuelle;
import java.util.ArrayList;
import java.util.List;

public final class PenaliteVector {
    private final List<Penalite> _penaliteVector = new ArrayList<Penalite>();

    public void add(Penalite penalite) {
        this._penaliteVector.add(penalite);
    }

    public void remove(Penalite penalite) {
        this._penaliteVector.remove(penalite);
    }

    public void clear() {
        this._penaliteVector.clear();
    }

    public List<Penalite> getPenaliteVector() {
        return this._penaliteVector;
    }

    public void removeEtape(Etape etape) {
        int i = 0;
        while (i < this._penaliteVector.size()) {
            if (this._penaliteVector.get(i).getEtape() == etape) {
                this._penaliteVector.remove(i);
                continue;
            }
            ++i;
        }
    }

    public Penalite getPenaliteAt(Etape etape, int index) {
        int tmp = 0;
        for (Penalite penalite : this._penaliteVector) {
            if (penalite.getEtape() != etape) continue;
            if (tmp == index) {
                return penalite;
            }
            ++tmp;
        }
        return null;
    }

    public List<String> getPenaltyCountForEtape(Etape etape) {
        ArrayList<String> result = new ArrayList<String>();
        for (Penalite penalite : this._penaliteVector) {
            if (penalite.getEtape() != etape) continue;
            result.add(penalite.getName());
        }
        return result;
    }

    public int getSanctionPoints(Parcours parcours, Etape etape, String puceId) {
        int count = 0;
        for (Penalite penalite : this._penaliteVector) {
            if (!penalite.getParcours().hasSameNameAs(parcours) || penalite.getEtape() != etape) continue;
            List<PenaliteIndividuelle> penaliteIndividuelleVector = penalite.getPenaliteIndividuelleVector();
            for (PenaliteIndividuelle penaliteIndividuelle : penaliteIndividuelleVector) {
                if (!penaliteIndividuelle.getPuceIds().contains(puceId)) continue;
                count += penaliteIndividuelle.getPoints();
            }
        }
        return count;
    }

    public int getSanctionTimeInS(Parcours parcours, Etape etape, String puceIds) {
        int count = 0;
        for (Penalite penalite : this._penaliteVector) {
            if (!penalite.getParcours().hasSameNameAs(parcours) || penalite.getEtape() != etape) continue;
            List<PenaliteIndividuelle> penaliteIndividuelles = penalite.getPenaliteIndividuelleVector();
            for (PenaliteIndividuelle penaliteIndividuelle : penaliteIndividuelles) {
                if (!penaliteIndividuelle.getPuceIds().contains(puceIds)) continue;
                count += penaliteIndividuelle.getTimeInS();
            }
        }
        return count;
    }
}

