/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.puce;

import fr.geraidv3.result.puce.Partiel;
import fr.geraidv3.utils.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.VisibleForTesting;

public final class Puce {
    private List<Partiel> _partiels = new ArrayList<Partiel>();
    private String _id = "";
    private Date _startTime = DateTimeUtils.NO_TIME;
    private Date _finishTime = DateTimeUtils.NO_TIME;
    private Date _checkTime = DateTimeUtils.NO_TIME;
    private Date _readTime = DateTimeUtils.NO_TIME;
    private Date _clearTime = DateTimeUtils.NO_TIME;

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public void setStartTime(Date date) {
        this._startTime = date;
    }

    public Date getFinishTime() {
        return this._finishTime;
    }

    public void setFinishTime(Date date) {
        this._finishTime = date;
    }

    public Date getClearTime() {
        return this._clearTime;
    }

    public void setClearTime(Date date) {
        this._clearTime = date;
    }

    public Date getCheckTime() {
        return this._checkTime;
    }

    public void setCheckTime(Date date) {
        this._checkTime = date;
    }

    public Date getReadTime() {
        return this._readTime;
    }

    public void setReadTime(Date date) {
        this._readTime = date;
    }

    public List<Partiel> getPartiels() {
        return this._partiels;
    }

    public void setPartiels(List<Partiel> partiels) {
        this._partiels = partiels;
    }

    public Partiel[] getPartielsAsArray() {
        return this._partiels.toArray(new Partiel[0]);
    }

    public void removePartiel(Partiel partiel) {
        this._partiels.remove(partiel);
    }

    public void moveUpPartiel(int index) {
        if (index > 0) {
            Collections.swap(this._partiels, index, index - 1);
        }
    }

    public void moveDownPartiel(int index) {
        if (index > -1 && index < this._partiels.size() - 1) {
            Collections.swap(this._partiels, index, index + 1);
        }
    }

    public int getPartielIndex(int code) {
        for (int i = 0; i < this._partiels.size(); ++i) {
            if (this._partiels.get(i).getCode() != code) continue;
            return i;
        }
        return -1;
    }

    public Date getTimeOfCodeNaturalOrder(int code) {
        for (Partiel partiel : this._partiels) {
            if (partiel.getCode() != code) continue;
            return partiel.getTimeAsDate();
        }
        return DateTimeUtils.NO_TIME;
    }

    public Date getTimeOfCodeReverseOrder(int code) {
        for (int i = this._partiels.size() - 1; i >= 0; --i) {
            Partiel partiel = this._partiels.get(i);
            if (partiel.getCode() != code) continue;
            return partiel.getTimeAsDate();
        }
        return DateTimeUtils.NO_TIME;
    }

    public Date getLastValidatedBaliseDateOfPreviousEpreuves(int[] baliseCodes) {
        for (int i = 0; i < this._partiels.size(); ++i) {
            Partiel partiel = this._partiels.get(i);
            if (!this._contains(baliseCodes, partiel.getCode())) continue;
            if (i > 0) {
                return this._partiels.get(i - 1).getTimeAsDate();
            }
            return this._partiels.get(i).getTimeAsDate();
        }
        return DateTimeUtils.NO_TIME;
    }

    public Date getFirstValidatedBaliseDateOfPreviousEpreuves(int[] baliseCodes) {
        for (int i = this._partiels.size() - 1; i >= 0; --i) {
            Partiel partiel = this._partiels.get(i);
            if (!this._contains(baliseCodes, partiel.getCode())) continue;
            if (i < this._partiels.size() - 1) {
                return this._partiels.get(i + 1).getTimeAsDate();
            }
            return this._partiels.get(i).getTimeAsDate();
        }
        return DateTimeUtils.NO_TIME;
    }

    public Date getTimeFirstValidatedBalise(int[] baliseCodes) {
        long time = Integer.MAX_VALUE;
        for (Partiel partiel : this._partiels) {
            long time1;
            if (!this._contains(baliseCodes, partiel.getCode()) || time <= (time1 = partiel.getTimeAsDate().getTime())) continue;
            time = partiel.getTimeAsDate().getTime();
        }
        if (time == Integer.MAX_VALUE) {
            return DateTimeUtils.NO_TIME;
        }
        return new Date(time);
    }

    public Date getTimeLastValidatedBalise(int[] baliseCodes) {
        long time = -1L;
        for (Partiel partiel : this._partiels) {
            long time1;
            if (!this._contains(baliseCodes, partiel.getCode()) || time >= (time1 = partiel.getTimeAsDate().getTime())) continue;
            time = partiel.getTimeAsDate().getTime();
        }
        if (time < 0L) {
            return DateTimeUtils.NO_TIME;
        }
        return new Date(time);
    }

    @VisibleForTesting
    public Date getPartielTimeOfLastCodeAfterFirstCode(int firstCode, int lastCode) {
        boolean isFirstCodePassed = false;
        for (Partiel partiel : this._partiels) {
            if (isFirstCodePassed && lastCode == partiel.getCode()) {
                return partiel.getTimeAsDate();
            }
            if (firstCode != partiel.getCode()) continue;
            isFirstCodePassed = true;
        }
        return DateTimeUtils.NO_TIME;
    }

    public int addPartiel(Partiel partiel) {
        int insertionIndex = 0;
        for (int i = 0; i < this._partiels.size(); ++i) {
            if (partiel.getTimeAsDate().before(this._partiels.get(i).getTimeAsDate())) {
                insertionIndex = i;
                break;
            }
            insertionIndex = i + 1;
        }
        this._partiels.add(insertionIndex, partiel);
        return insertionIndex;
    }

    public int movePartiel(Partiel partiel) {
        this._partiels.remove(partiel);
        return this.addPartiel(partiel);
    }

    List<Long> getTimesInMilliseconds() {
        ArrayList<Long> temps = new ArrayList<Long>();
        for (Partiel partiel : this._partiels) {
            temps.add(partiel.getTimeAsDate().getTime());
        }
        return temps;
    }

    List<Integer> getCodes() {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        for (Partiel partiel : this._partiels) {
            codes.add(partiel.getCode());
        }
        return codes;
    }

    private boolean _contains(int[] array, int value) {
        for (int element : array) {
            if (element != value) continue;
            return true;
        }
        return false;
    }
}

