/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.puce;

import fr.geraidv3.model.equipe.Equipe;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.Parcours;
import fr.geraidv3.result.puce.PuceResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jetbrains.annotations.VisibleForTesting;

public final class PuceResultVector {
    private final List<PuceResult> _puceResultVector = new ArrayList<PuceResult>();

    public List<PuceResult> getPuceResultVector() {
        return this._puceResultVector;
    }

    public void addPuceResult(PuceResult puceResult) {
        this._puceResultVector.add(puceResult);
    }

    public void andOrReplacePuceResult(PuceResult puceResult) {
        PuceResult oldPuceResult = this.existsPuceResult(puceResult);
        if (oldPuceResult != null) {
            this._puceResultVector.remove(oldPuceResult);
        }
        this._puceResultVector.add(puceResult);
    }

    public int getSize() {
        return this._puceResultVector.size();
    }

    public void clear() {
        this._puceResultVector.clear();
    }

    public void removePuceResult(PuceResult puceResult) {
        this._puceResultVector.remove(puceResult);
    }

    public void removeEtape(Etape etape) {
        int i = 0;
        while (i < this._puceResultVector.size()) {
            if (this._puceResultVector.get(i).getEtape() == etape) {
                this._puceResultVector.remove(i);
                continue;
            }
            ++i;
        }
    }

    public Vector<Parcours> getAllParcours() {
        Vector<Parcours> result = new Vector<Parcours>();
        for (PuceResult puceResult : this._puceResultVector) {
            if (result.contains(puceResult.getParcours())) continue;
            result.add(puceResult.getParcours());
        }
        return result;
    }

    public Vector<Etape> getEtapesForParcours(Parcours parcours) {
        Vector<Etape> result = new Vector<Etape>();
        for (PuceResult puceResult : this._puceResultVector) {
            if (puceResult.getParcours() != parcours || result.contains(puceResult.getEtape())) continue;
            result.add(puceResult.getEtape());
        }
        return result;
    }

    public Vector<Equipe> getEquipesForEtape(Etape etape) {
        Vector<Equipe> result = new Vector<Equipe>();
        for (PuceResult puceResult : this._puceResultVector) {
            if (puceResult.getEtape() != etape || result.contains(puceResult.getEquipe())) continue;
            result.add(puceResult.getEquipe());
        }
        return result;
    }

    public PuceResult getPuceResult(Etape etape, Equipe equipe) {
        for (PuceResult puceResult : this._puceResultVector) {
            if (puceResult.getEtape() != etape || puceResult.getEquipe() != equipe) continue;
            return puceResult;
        }
        return null;
    }

    public PuceResult getPuceResult(Parcours parcours, Etape etape, String[] puceIds) {
        for (String puceId : puceIds) {
            PuceResult puceResult = this.getPuceResult(parcours, etape, puceId);
            if (puceResult == null) continue;
            return puceResult;
        }
        return null;
    }

    public PuceResult getPuceResult(Parcours parcours, Etape etape, String puceId) {
        for (PuceResult puceResult : this._puceResultVector) {
            if (parcours != puceResult.getParcours() || etape != puceResult.getEtape() || !puceResult.getPuce().getId().equals(puceId)) continue;
            return puceResult;
        }
        return null;
    }

    public PuceResult existsPuceResult(PuceResult puceResult) {
        for (PuceResult puceResult1 : this._puceResultVector) {
            if (!this._isSame(puceResult1, puceResult)) continue;
            return puceResult1;
        }
        return null;
    }

    public void removePuceResultForParcours(Parcours parcours) {
        int i = 0;
        while (i < this._puceResultVector.size()) {
            if (this._puceResultVector.get(i).getParcours() == parcours) {
                this._puceResultVector.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void removePuceResultForEquipe(Equipe equipe) {
        int i = 0;
        while (i < this._puceResultVector.size()) {
            if (this._puceResultVector.get(i).getEquipe() == equipe) {
                this._puceResultVector.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean isArrived(Equipe equipe, Parcours parcours, Etape etape) {
        boolean result = false;
        for (PuceResult puceResult : this._puceResultVector) {
            if (puceResult.getEtape() != etape || puceResult.getEquipe() != equipe || puceResult.getParcours() != parcours) continue;
            return true;
        }
        return false;
    }

    public boolean existsPuceResult(Equipe equipe) {
        for (PuceResult puceResult : this._puceResultVector) {
            if (puceResult.getEquipe() != equipe) continue;
            return true;
        }
        return false;
    }

    public boolean existsPuceResultForId(String puceId) {
        for (PuceResult puceResult : this._puceResultVector) {
            if (!puceResult.getPuce().getId().equals(puceId)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean _isSame(PuceResult puceResult1, PuceResult puceResult2) {
        return puceResult1.getEtape() == puceResult2.getEtape() && puceResult1.getEquipe() == puceResult2.getEquipe() && puceResult1.getPuce().getId().equals(puceResult2.getPuce().getId());
    }
}

