/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.result.puce;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.geraidv3.L10n;
import fr.geraidv3.model.epreuve.Epreuve;
import fr.geraidv3.model.etape.Etape;
import fr.geraidv3.model.parcours.ParcoursVariante;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.VisibleForTesting;

public final class PucesSpecificationsHandler {
    private final List<Map<String, String>> _pucesSpecifications = PucesSpecificationsHandler._getListSpecifications();

    public boolean isPuceIncompatibleWithParcours(String puceId, ParcoursVariante variante, StringBuilder errorMessage) {
        return !PucesSpecificationsHandler._isPuceCompatibleWithParcours(puceId, variante, this._pucesSpecifications, errorMessage);
    }

    @VisibleForTesting
    static boolean _isPuceCompatibleWithParcours(String puceId, ParcoursVariante variante, List<Map<String, String>> listSpecifications, StringBuilder errorMessage) {
        int puce;
        if (puceId.isEmpty()) {
            return true;
        }
        try {
            puce = Integer.parseInt(puceId);
        }
        catch (NumberFormatException e) {
            return false;
        }
        for (Map<String, String> specifications : listSpecifications) {
            int minPuce = Integer.parseInt(specifications.get("min"));
            int maxPuce = Integer.parseInt(specifications.get("max"));
            if (puce < minPuce || puce > maxPuce) continue;
            int memory = Integer.parseInt(specifications.get("memory"));
            return PucesSpecificationsHandler._hasTooBigEtape(variante, memory, errorMessage);
        }
        return true;
    }

    @VisibleForTesting
    static boolean _hasTooBigEtape(ParcoursVariante variante, int puceCapacity, StringBuilder errorMessage) {
        for (Etape etape : variante.getEtapeVector()) {
            int baliseCounter = 0;
            for (Epreuve epreuve : variante.getEpreuvesOfEtape(etape).getEpreuveVector()) {
                baliseCounter += epreuve.getBaliseVector().getSize();
            }
            if (baliseCounter <= puceCapacity) continue;
            errorMessage.append(L10n.getString("puce_specification.errorMessage", baliseCounter, puceCapacity));
            return false;
        }
        return true;
    }

    private static List<Map<String, String>> _getListSpecifications() {
        try {
            InputStream inputStream = PucesSpecificationsHandler.class.getResourceAsStream("/fr/geraidv3/puces_specifications.json");
            assert (inputStream != null);
            ObjectMapper objectMapper = new ObjectMapper();
            TypeReference<List<Map<String, String>>> objectTypeReference = new TypeReference<List<Map<String, String>>>(){};
            return (List)objectMapper.readValue(inputStream, (TypeReference)objectTypeReference);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }
}

