/*
 * Decompiled with CFR 0.152.
 */
package fr.geraidv3.utils;

import fr.geraidv3.GeRaidV3;
import fr.geraidv3.L10n;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jetbrains.annotations.VisibleForTesting;

public final class DateTimeUtils {
    public static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    public static final Date NO_TIME = new Date(90000000000L);
    private static final SimpleDateFormat FORMATTER_HMS = new SimpleDateFormat("H:mm:ss");
    private static final SimpleDateFormat FORMATTER_MS;
    private static final SimpleDateFormat FORMATTER_D_HMS;
    private static final String NO_TIME_STRING = "--:--";

    public static String getLocaleDateTime() {
        GregorianCalendar calendar = new GregorianCalendar(GeRaidV3.getLocaleTimeZone());
        return calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + L10n.getString("hour_abbreviation") + calendar.get(12) + L10n.getString("minute_abbreviation") + calendar.get(13) + L10n.getString("second_abbreviation");
    }

    public static long getLocaleDateInMs() {
        GregorianCalendar calendar = new GregorianCalendar(GeRaidV3.getLocaleTimeZone());
        return calendar.getTime().getTime();
    }

    public static Date parseLocalTime(String time) throws ParseException {
        return FORMATTER_HMS.parse(time);
    }

    public static Date safeParseTime(String time) {
        try {
            if (DateTimeUtils._countSemiColons(time) == 2) {
                return FORMATTER_D_HMS.parse("00:".concat(time));
            }
            return FORMATTER_D_HMS.parse(time);
        }
        catch (NullPointerException | ParseException exception) {
            return NO_TIME;
        }
    }

    public static String dateToString(Date date) {
        if (date.equals(NO_TIME)) {
            return NO_TIME_STRING;
        }
        if (date.getTime() > 86400000L) {
            int hours = DateTimeUtils.getHoursFromDate(date);
            String h = String.format("%02d", hours);
            int minutes = DateTimeUtils.getMinutesFromDate(date);
            String mn = String.format("%02d", minutes);
            int seconds = DateTimeUtils.getSecondsFromDate(date);
            String s = String.format("%02d", seconds);
            return h + ":" + mn + ":" + s;
        }
        return FORMATTER_HMS.format(date);
    }

    public static String millisecondsToString(long timestampInMs) {
        if (timestampInMs < 0L) {
            return "-" + DateTimeUtils.dateToString(new Date(-timestampInMs));
        }
        return DateTimeUtils.dateToString(new Date(timestampInMs));
    }

    public static Date dateFromMilliseconds(String milliseconds) {
        if (milliseconds.equals("0")) {
            return new Date(0L);
        }
        return new Date(Long.parseLong(milliseconds));
    }

    public static int getHoursFromDate(Date date) {
        long milliseconds = date.getTime();
        return (int)Math.floor((double)milliseconds / 3600000.0);
    }

    public static int getMinutesFromDate(Date date) {
        long milliseconds = date.getTime() - (long)DateTimeUtils.getHoursFromDate(date) * 3600000L;
        return (int)Math.floor((double)milliseconds / 60000.0);
    }

    public static int getSecondsFromDate(Date date) {
        long milliseconds = date.getTime() - (long)DateTimeUtils.getHoursFromDate(date) * 3600000L - (long)DateTimeUtils.getMinutesFromDate(date) * 60000L;
        return (int)Math.floor((double)milliseconds / 1000.0);
    }

    public static Date setHoursToDate(Date date, int hours) {
        return new Date(((long)hours * 3600L + (long)DateTimeUtils.getMinutesFromDate(date) * 60L + (long)DateTimeUtils.getSecondsFromDate(date)) * 1000L);
    }

    public static Date setMinutesToDate(Date date, int minutes) {
        return new Date(((long)DateTimeUtils.getHoursFromDate(date) * 3600L + (long)minutes * 60L + (long)DateTimeUtils.getSecondsFromDate(date)) * 1000L);
    }

    public static Date setSecondsToDate(Date date, int seconds) {
        return new Date(((long)DateTimeUtils.getHoursFromDate(date) * 3600L + (long)DateTimeUtils.getMinutesFromDate(date) * 60L + (long)seconds) * 1000L);
    }

    public static long getAbsoluteElapsedTimeInMillis(Date date1, Date date2) {
        switch (date1.compareTo(date2)) {
            case 1: {
                return date1.getTime() - date2.getTime();
            }
            case -1: {
                return date2.getTime() - date1.getTime();
            }
        }
        return 0L;
    }

    @VisibleForTesting
    static int _countSemiColons(String string) {
        return (int)string.chars().filter(ch -> ch == 58).count();
    }

    static {
        FORMATTER_HMS.setTimeZone(TimeZone.getTimeZone("GMT"));
        FORMATTER_MS = new SimpleDateFormat("m:ss");
        FORMATTER_MS.setTimeZone(TimeZone.getTimeZone("GMT"));
        FORMATTER_D_HMS = new SimpleDateFormat("dd:HH:mm:ss");
        FORMATTER_D_HMS.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

