/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.adapter.rxtx;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.gecosi.internal.SportIdentMessage;
import net.gecosi.internal.SportIdentMessageQueue;

public final class RxtxCommReader
implements SerialPortDataListener {
    private static final int MAX_MESSAGE_SIZE = 139;
    private static final int METADATA_SIZE = 6;
    private final InputStream _input;
    private final SportIdentMessageQueue _messageQueue;
    private final int _timeoutDelay;
    private byte[] _accumulator;
    private int _accSize;
    private long _lastTime;

    public RxtxCommReader(InputStream input, SportIdentMessageQueue messageQueue) {
        this(input, messageQueue, 500);
    }

    public RxtxCommReader(InputStream input, SportIdentMessageQueue messageQueue, int timeout) {
        this._input = input;
        this._messageQueue = messageQueue;
        this._timeoutDelay = timeout;
        this._lastTime = 0L;
    }

    public void serialEvent(SerialPortEvent event) {
        try {
            this.checkTimeout();
            this.accumulate();
            if (this._accSize == 1 && this._accumulator[0] != 2) {
                this.sendMessage();
            } else {
                this.checkExpectedLength(this._accumulator, this._accSize);
            }
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getListeningEvents() {
        return 1;
    }

    private void resetAccumulator() {
        this._accumulator = new byte[139];
        this._accSize = 0;
    }

    private void accumulate() throws IOException {
        this._accSize += this._input.read(this._accumulator, this._accSize, 139 - this._accSize);
    }

    private void checkTimeout() {
        long currentTime = System.currentTimeMillis();
        if (currentTime > this._lastTime + (long)this._timeoutDelay) {
            this.resetAccumulator();
        }
        this._lastTime = currentTime;
    }

    private void checkExpectedLength(byte[] accumulator, int accSize) throws InterruptedException {
        if (this.completeMessage(accumulator, accSize)) {
            this.sendMessage();
        }
    }

    private boolean completeMessage(byte[] answer, int nbReadBytes) {
        return (answer[2] & 0xFF) == nbReadBytes - 6;
    }

    private void sendMessage() throws InterruptedException {
        this.queueMessage(this.extractMessage(this._accumulator, this._accSize));
        this.resetAccumulator();
    }

    private void queueMessage(SportIdentMessage message) throws InterruptedException {
        this._messageQueue.put(message);
    }

    private SportIdentMessage extractMessage(byte[] answer, int nbBytes) {
        return new SportIdentMessage(Arrays.copyOfRange(answer, 0, nbBytes));
    }
}

