/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.dataframe;

import java.util.Arrays;
import net.gecosi.dataframe.SportIdentAbstractDataFrame;
import net.gecosi.dataframe.SportIdentDataFrame;
import net.gecosi.dataframe.SportIdentPunch;
import net.gecosi.internal.SportIdentMessage;

public class SportIdent5DataFrame
extends SportIdentAbstractDataFrame {
    private static final int SI5_TIMED_PUNCHES = 30;

    public SportIdent5DataFrame(SportIdentMessage message) {
        this.setDataFrame(this.extractDataFrame(message));
        this.siNumber = this.extractSiNumber();
    }

    @Override
    public SportIdentDataFrame startingAt(long zeroHour) {
        this.startTime = this.advanceTimePast(this.rawStartTime(), zeroHour);
        this.checkTime = this.advanceTimePast(this.rawCheckTime(), zeroHour);
        long refTime = this.newRefTime(zeroHour, this.startTime);
        this.punches = this.computeShiftedPunches(refTime);
        if (this.punches.length > 0) {
            SportIdentPunch lastTimedPunch = this.punches[this.nbTimedPunches(this.punches) - 1];
            refTime = this.newRefTime(refTime, lastTimedPunch.timestamp());
        }
        this.finishTime = this.advanceTimePast(this.rawFinishTime(), refTime);
        return this;
    }

    public long advanceTimePast(long timestamp, long refTime) {
        return this.advanceTimePast(timestamp, refTime, 43200000L);
    }

    @Override
    public String getSiSeries() {
        return "SiCard 5";
    }

    private byte[] extractDataFrame(SportIdentMessage message) {
        return Arrays.copyOfRange(message.sequence(), 5, 133);
    }

    private SportIdentPunch[] computeShiftedPunches(long startTime) {
        int i;
        int nbPunches = this.rawNbPunches();
        SportIdentPunch[] punches = new SportIdentPunch[nbPunches];
        int nbTimedPunches = this.nbTimedPunches(punches);
        long refTime = startTime;
        for (i = 0; i < nbTimedPunches; ++i) {
            long punchTime = this.advanceTimePast(this.getPunchTime(i), refTime);
            punches[i] = new SportIdentPunch(this.getPunchCode(i), punchTime);
            refTime = this.newRefTime(refTime, punchTime);
        }
        for (i = 0; i < nbPunches - 30; ++i) {
            punches[i + 30] = new SportIdentPunch(this.getNoTimePunchCode(i), -1L);
        }
        return punches;
    }

    private int nbTimedPunches(SportIdentPunch[] punches) {
        return Math.min(punches.length, 30);
    }

    private String extractSiNumber() {
        int siNumber = this.wordAt(4);
        int cns = this.byteAt(6);
        if (cns > 1) {
            siNumber += cns * 100000;
        }
        return Integer.toString(siNumber);
    }

    private int rawNbPunches() {
        return this.byteAt(23) - 1;
    }

    private long rawStartTime() {
        return this.timestampAt(19);
    }

    private long rawFinishTime() {
        return this.timestampAt(21);
    }

    private long rawCheckTime() {
        return this.timestampAt(25);
    }

    protected int punchOffset(int i) {
        return 33 + i / 5 * 16 + i % 5 * 3;
    }

    private int getPunchCode(int i) {
        return this.byteAt(this.punchOffset(i));
    }

    private int getNoTimePunchCode(int i) {
        return this.byteAt(32 + i * 16);
    }

    private long getPunchTime(int i) {
        return this.timestampAt(this.punchOffset(i) + 1);
    }
}

