/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.dataframe;

import net.gecosi.dataframe.SportIdent6PlusAbstractDataFrame;
import net.gecosi.dataframe.SportIdentPunch;
import net.gecosi.internal.SportIdentMessage;

public final class SportIdent6DataFrame
extends SportIdent6PlusAbstractDataFrame {
    private static final int PAGE_SIZE = 16;
    private static final int DOUBLE_WORD = 4;
    public static final int NB_PUNCHES_INDEX = 18;

    public SportIdent6DataFrame(SportIdentMessage[] dataMessages) {
        super(dataMessages);
    }

    @Override
    protected int siNumberIndex() {
        return 11;
    }

    @Override
    protected int startTimeIndex() {
        return 24;
    }

    @Override
    protected int finishTimeIndex() {
        return 20;
    }

    @Override
    protected int checkTimeIndex() {
        return 28;
    }

    @Override
    protected int nbPunchesIndex() {
        return 18;
    }

    private int punchesStartIndex() {
        return 128;
    }

    @Override
    protected SportIdentPunch[] extractPunches(long startTime) {
        SportIdentPunch[] punches = new SportIdentPunch[this.rawNbPunches()];
        int punchesStart = this.punchesStartIndex();
        long refTime = startTime;
        for (int i = 0; i < punches.length; ++i) {
            int punchIndex = punchesStart + 4 * i;
            long punchTime = this.advanceTimePast(this.extractFullTime(punchIndex), refTime);
            punches[i] = new SportIdentPunch(this.extractCode(punchIndex), punchTime);
            refTime = this.newRefTime(refTime, punchTime);
        }
        return punches;
    }

    @Override
    public String getSiSeries() {
        return "SiCard 6";
    }
}

