/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.internal;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.gecosi.CommStatus;
import net.gecosi.SportIdentHandler;
import net.gecosi.internal.CommWriter;
import net.gecosi.internal.InvalidMessage;
import net.gecosi.internal.SportIdentDriverState;
import net.gecosi.internal.SportIdentMessageQueue;
import net.gecosi.internal.SportIdentPort;

public final class SportIdentDriver
implements Runnable {
    private final SportIdentPort _sportIdentPort;
    private final CommWriter _writer;
    private final SportIdentMessageQueue _messageQueue;
    private final SportIdentHandler _sportIdentHandler;
    private Thread _thread;

    public SportIdentDriver(SportIdentPort sportIdentPort, SportIdentHandler sportIdentHandler) throws IOException {
        this._sportIdentPort = sportIdentPort;
        this._messageQueue = sportIdentPort.createMessageQueue();
        this._writer = sportIdentPort.createWriter();
        this._sportIdentHandler = sportIdentHandler;
    }

    public SportIdentDriver start() {
        this._thread = new Thread(this);
        this._thread.start();
        return this;
    }

    public void interrupt() {
        this._thread.interrupt();
    }

    @Override
    public void run() {
        try {
            SportIdentDriverState currentState = this.startupBootstrap();
            while (this.isAlive(currentState)) {
                currentState = currentState.receive(this._messageQueue, this._writer, this._sportIdentHandler);
            }
            if (currentState.isError()) {
                this._sportIdentHandler.notifyError(CommStatus.FATAL_ERROR, currentState.status());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this._sportIdentHandler.notifyError(CommStatus.FATAL_ERROR, null);
        }
        finally {
            this.stop();
        }
    }

    private boolean isAlive(SportIdentDriverState currentState) {
        return !this._thread.isInterrupted() && !currentState.isError();
    }

    private SportIdentDriverState startupBootstrap() throws IOException, InterruptedException, InvalidMessage {
        try {
            this._sportIdentHandler.notify(CommStatus.STARTING);
            this._sportIdentPort.setupHighSpeed();
            return this.startup();
        }
        catch (TimeoutException e) {
            try {
                this._sportIdentPort.setupLowSpeed();
                return this.startup();
            }
            catch (TimeoutException e1) {
                return SportIdentDriverState.STARTUP_TIMEOUT;
            }
        }
    }

    private SportIdentDriverState startup() throws IOException, InterruptedException, TimeoutException, InvalidMessage {
        return SportIdentDriverState.STARTUP.send(this._writer, this._sportIdentHandler).receive(this._messageQueue, this._writer, this._sportIdentHandler);
    }

    private void stop() {
        this._sportIdentPort.close();
        this._sportIdentHandler.notify(CommStatus.OFF);
    }
}

