/*
 * Decompiled with CFR 0.152.
 */
package net.gecosi.internal;

import de.sportident.CRCCalculator;
import java.io.Serializable;
import java.io.StringWriter;

public final class SportIdentMessage
implements Serializable {
    private final byte[] _sequence;
    public static final byte WAKEUP = -1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte ACK = 6;
    public static final byte GET_SYSTEM_VALUE = -125;
    public static final byte SET_MASTER_MODE = -16;
    public static final byte DIRECT_MODE = 77;
    public static final byte BEEP = -7;
    public static final byte SPORT_IDENT_CARD_5_DETECTED = -27;
    public static final byte SPORT_IDENT_CARD_6_PLUS_DETECTED = -26;
    public static final byte SPORT_IDENT_CARD_8_PLUS_DETECTED = -24;
    public static final byte SPORT_IDENT_CARD_REMOVED = -25;
    public static final byte GET_SPORT_IDENT_CARD_5 = -79;
    public static final byte GET_SPORT_IDENT_CARD_6_BN = -31;
    public static final byte GET_SPORT_IDENT_CARD_8_PLUS_BN = -17;
    public static final int SI3_NUMBER_INDEX = 5;
    public static final byte SPORT_IDENT_CARD_10_PLUS_SERIES = 15;
    public static final SportIdentMessage startup_sequence = new SportIdentMessage(new byte[]{-1, 2, 2, -16, 1, 77, 109, 10, 3});
    public static final SportIdentMessage get_protocol_configuration = new SportIdentMessage(new byte[]{2, -125, 2, 116, 1, 4, 20, 3});
    public static final SportIdentMessage get_cardblocks_configuration = new SportIdentMessage(new byte[]{2, -125, 2, 51, 1, 22, 17, 3});
    public static final SportIdentMessage ack_sequence = new SportIdentMessage(new byte[]{6});
    public static final SportIdentMessage read_sport_ident_card_5 = new SportIdentMessage(new byte[]{2, -79, 0, -79, 0, 3});
    public static final SportIdentMessage read_sport_ident_card_6_b0 = new SportIdentMessage(new byte[]{2, -31, 1, 0, 70, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_plus_b2 = new SportIdentMessage(new byte[]{2, -31, 1, 2, 68, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_plus_b3 = new SportIdentMessage(new byte[]{2, -31, 1, 3, 69, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_plus_b4 = new SportIdentMessage(new byte[]{2, -31, 1, 4, 66, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_plus_b5 = new SportIdentMessage(new byte[]{2, -31, 1, 5, 67, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_b6 = new SportIdentMessage(new byte[]{2, -31, 1, 6, 64, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_6_b7 = new SportIdentMessage(new byte[]{2, -31, 1, 7, 65, 10, 3});
    public static final SportIdentMessage read_sport_ident_card_8_plus_b0 = new SportIdentMessage(new byte[]{2, -17, 1, 0, -30, 9, 3});
    public static final SportIdentMessage read_sport_ident_card_8_plus_b1 = new SportIdentMessage(new byte[]{2, -17, 1, 1, -29, 9, 3});
    public static final SportIdentMessage read_sport_ident_card_10_plus_b0 = read_sport_ident_card_8_plus_b0;
    public static final SportIdentMessage read_sport_ident_card_10_plus_b4 = new SportIdentMessage(new byte[]{2, -17, 1, 4, -26, 9, 3});
    public static final SportIdentMessage read_sport_ident_card_10_plus_b5 = new SportIdentMessage(new byte[]{2, -17, 1, 5, -25, 9, 3});
    public static final SportIdentMessage read_sport_ident_card_10_plus_b6 = new SportIdentMessage(new byte[]{2, -17, 1, 6, -28, 9, 3});
    public static final SportIdentMessage read_sport_ident_card_10_plus_b7 = new SportIdentMessage(new byte[]{2, -17, 1, 7, -27, 9, 3});
    public static final SportIdentMessage beep_twice = new SportIdentMessage(new byte[]{2, -7, 1, 2, 20, 10, 3});

    public SportIdentMessage(byte[] sequence) {
        this._sequence = sequence;
    }

    public byte[] sequence() {
        return this._sequence;
    }

    public byte sequence(int i) {
        return this._sequence[i];
    }

    public byte[] data() {
        int cmdLength = this._sequence.length - 4;
        byte[] command = new byte[cmdLength];
        System.arraycopy(this._sequence, 1, command, 0, cmdLength);
        return command;
    }

    public byte commandByte() {
        return this._sequence[1];
    }

    public byte startByte() {
        return this._sequence[0];
    }

    public byte endByte() {
        return this._sequence[this._sequence.length - 1];
    }

    public int extractCRC() {
        int i = this._sequence.length;
        return this._sequence[i - 3] << 8 & 0xFFFF | this._sequence[i - 2] & 0xFF;
    }

    public int computeCRC() {
        return CRCCalculator.crc(this.data());
    }

    public boolean check(byte command) {
        return this.valid() && this.commandByte() == command;
    }

    public boolean valid() {
        return this.startByte() == 2 && this.endByte() == 3 && this.validCRC();
    }

    public boolean validCRC() {
        return this.computeCRC() == this.extractCRC();
    }

    public String toString() {
        StringWriter buf = new StringWriter(this._sequence.length);
        for (byte b : this._sequence) {
            buf.write(String.format("%02X ", b));
        }
        return buf.toString();
    }
}

